/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.opsworks.model.ChefConfiguration;
import com.amazonaws.services.opsworks.model.RootDeviceType;
import com.amazonaws.services.opsworks.model.Source;
import com.amazonaws.services.opsworks.model.StackConfigurationManager;
import com.amazonaws.services.opsworks.model.transform.StackMarshaller;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Map;

public class Stack
implements Serializable,
Cloneable,
StructuredPojo {
    private String stackId;
    private String name;
    private String arn;
    private String region;
    private String vpcId;
    private SdkInternalMap<String, String> attributes;
    private String serviceRoleArn;
    private String defaultInstanceProfileArn;
    private String defaultOs;
    private String hostnameTheme;
    private String defaultAvailabilityZone;
    private String defaultSubnetId;
    private String customJson;
    private StackConfigurationManager configurationManager;
    private ChefConfiguration chefConfiguration;
    private Boolean useCustomCookbooks;
    private Boolean useOpsworksSecurityGroups;
    private Source customCookbooksSource;
    private String defaultSshKeyName;
    private String createdAt;
    private String defaultRootDeviceType;
    private String agentVersion;

    public void setStackId(String stackId) {
        this.stackId = stackId;
    }

    public String getStackId() {
        return this.stackId;
    }

    public Stack withStackId(String stackId) {
        this.setStackId(stackId);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Stack withName(String name) {
        this.setName(name);
        return this;
    }

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public Stack withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getRegion() {
        return this.region;
    }

    public Stack withRegion(String region) {
        this.setRegion(region);
        return this;
    }

    public void setVpcId(String vpcId) {
        this.vpcId = vpcId;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public Stack withVpcId(String vpcId) {
        this.setVpcId(vpcId);
        return this;
    }

    public Map<String, String> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new SdkInternalMap();
        }
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes == null ? null : new SdkInternalMap<String, String>(attributes);
    }

    public Stack withAttributes(Map<String, String> attributes) {
        this.setAttributes(attributes);
        return this;
    }

    public Stack addAttributesEntry(String key, String value) {
        if (null == this.attributes) {
            this.attributes = new SdkInternalMap();
        }
        if (this.attributes.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.attributes.put(key, value);
        return this;
    }

    public Stack clearAttributesEntries() {
        this.attributes = null;
        return this;
    }

    public void setServiceRoleArn(String serviceRoleArn) {
        this.serviceRoleArn = serviceRoleArn;
    }

    public String getServiceRoleArn() {
        return this.serviceRoleArn;
    }

    public Stack withServiceRoleArn(String serviceRoleArn) {
        this.setServiceRoleArn(serviceRoleArn);
        return this;
    }

    public void setDefaultInstanceProfileArn(String defaultInstanceProfileArn) {
        this.defaultInstanceProfileArn = defaultInstanceProfileArn;
    }

    public String getDefaultInstanceProfileArn() {
        return this.defaultInstanceProfileArn;
    }

    public Stack withDefaultInstanceProfileArn(String defaultInstanceProfileArn) {
        this.setDefaultInstanceProfileArn(defaultInstanceProfileArn);
        return this;
    }

    public void setDefaultOs(String defaultOs) {
        this.defaultOs = defaultOs;
    }

    public String getDefaultOs() {
        return this.defaultOs;
    }

    public Stack withDefaultOs(String defaultOs) {
        this.setDefaultOs(defaultOs);
        return this;
    }

    public void setHostnameTheme(String hostnameTheme) {
        this.hostnameTheme = hostnameTheme;
    }

    public String getHostnameTheme() {
        return this.hostnameTheme;
    }

    public Stack withHostnameTheme(String hostnameTheme) {
        this.setHostnameTheme(hostnameTheme);
        return this;
    }

    public void setDefaultAvailabilityZone(String defaultAvailabilityZone) {
        this.defaultAvailabilityZone = defaultAvailabilityZone;
    }

    public String getDefaultAvailabilityZone() {
        return this.defaultAvailabilityZone;
    }

    public Stack withDefaultAvailabilityZone(String defaultAvailabilityZone) {
        this.setDefaultAvailabilityZone(defaultAvailabilityZone);
        return this;
    }

    public void setDefaultSubnetId(String defaultSubnetId) {
        this.defaultSubnetId = defaultSubnetId;
    }

    public String getDefaultSubnetId() {
        return this.defaultSubnetId;
    }

    public Stack withDefaultSubnetId(String defaultSubnetId) {
        this.setDefaultSubnetId(defaultSubnetId);
        return this;
    }

    public void setCustomJson(String customJson) {
        this.customJson = customJson;
    }

    public String getCustomJson() {
        return this.customJson;
    }

    public Stack withCustomJson(String customJson) {
        this.setCustomJson(customJson);
        return this;
    }

    public void setConfigurationManager(StackConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }

    public StackConfigurationManager getConfigurationManager() {
        return this.configurationManager;
    }

    public Stack withConfigurationManager(StackConfigurationManager configurationManager) {
        this.setConfigurationManager(configurationManager);
        return this;
    }

    public void setChefConfiguration(ChefConfiguration chefConfiguration) {
        this.chefConfiguration = chefConfiguration;
    }

    public ChefConfiguration getChefConfiguration() {
        return this.chefConfiguration;
    }

    public Stack withChefConfiguration(ChefConfiguration chefConfiguration) {
        this.setChefConfiguration(chefConfiguration);
        return this;
    }

    public void setUseCustomCookbooks(Boolean useCustomCookbooks) {
        this.useCustomCookbooks = useCustomCookbooks;
    }

    public Boolean getUseCustomCookbooks() {
        return this.useCustomCookbooks;
    }

    public Stack withUseCustomCookbooks(Boolean useCustomCookbooks) {
        this.setUseCustomCookbooks(useCustomCookbooks);
        return this;
    }

    public Boolean isUseCustomCookbooks() {
        return this.useCustomCookbooks;
    }

    public void setUseOpsworksSecurityGroups(Boolean useOpsworksSecurityGroups) {
        this.useOpsworksSecurityGroups = useOpsworksSecurityGroups;
    }

    public Boolean getUseOpsworksSecurityGroups() {
        return this.useOpsworksSecurityGroups;
    }

    public Stack withUseOpsworksSecurityGroups(Boolean useOpsworksSecurityGroups) {
        this.setUseOpsworksSecurityGroups(useOpsworksSecurityGroups);
        return this;
    }

    public Boolean isUseOpsworksSecurityGroups() {
        return this.useOpsworksSecurityGroups;
    }

    public void setCustomCookbooksSource(Source customCookbooksSource) {
        this.customCookbooksSource = customCookbooksSource;
    }

    public Source getCustomCookbooksSource() {
        return this.customCookbooksSource;
    }

    public Stack withCustomCookbooksSource(Source customCookbooksSource) {
        this.setCustomCookbooksSource(customCookbooksSource);
        return this;
    }

    public void setDefaultSshKeyName(String defaultSshKeyName) {
        this.defaultSshKeyName = defaultSshKeyName;
    }

    public String getDefaultSshKeyName() {
        return this.defaultSshKeyName;
    }

    public Stack withDefaultSshKeyName(String defaultSshKeyName) {
        this.setDefaultSshKeyName(defaultSshKeyName);
        return this;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public String getCreatedAt() {
        return this.createdAt;
    }

    public Stack withCreatedAt(String createdAt) {
        this.setCreatedAt(createdAt);
        return this;
    }

    public void setDefaultRootDeviceType(String defaultRootDeviceType) {
        this.defaultRootDeviceType = defaultRootDeviceType;
    }

    @JsonProperty(value="defaultRootDeviceType")
    public String getDefaultRootDeviceType() {
        return this.defaultRootDeviceType;
    }

    public Stack withDefaultRootDeviceType(String defaultRootDeviceType) {
        this.setDefaultRootDeviceType(defaultRootDeviceType);
        return this;
    }

    @JsonIgnore
    public void setDefaultRootDeviceType(RootDeviceType defaultRootDeviceType) {
        this.withDefaultRootDeviceType(defaultRootDeviceType);
    }

    public Stack withDefaultRootDeviceType(RootDeviceType defaultRootDeviceType) {
        this.defaultRootDeviceType = defaultRootDeviceType.toString();
        return this;
    }

    public void setAgentVersion(String agentVersion) {
        this.agentVersion = agentVersion;
    }

    public String getAgentVersion() {
        return this.agentVersion;
    }

    public Stack withAgentVersion(String agentVersion) {
        this.setAgentVersion(agentVersion);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStackId() != null) {
            sb.append("StackId: ").append(this.getStackId()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn()).append(",");
        }
        if (this.getRegion() != null) {
            sb.append("Region: ").append(this.getRegion()).append(",");
        }
        if (this.getVpcId() != null) {
            sb.append("VpcId: ").append(this.getVpcId()).append(",");
        }
        if (this.getAttributes() != null) {
            sb.append("Attributes: ").append(this.getAttributes()).append(",");
        }
        if (this.getServiceRoleArn() != null) {
            sb.append("ServiceRoleArn: ").append(this.getServiceRoleArn()).append(",");
        }
        if (this.getDefaultInstanceProfileArn() != null) {
            sb.append("DefaultInstanceProfileArn: ").append(this.getDefaultInstanceProfileArn()).append(",");
        }
        if (this.getDefaultOs() != null) {
            sb.append("DefaultOs: ").append(this.getDefaultOs()).append(",");
        }
        if (this.getHostnameTheme() != null) {
            sb.append("HostnameTheme: ").append(this.getHostnameTheme()).append(",");
        }
        if (this.getDefaultAvailabilityZone() != null) {
            sb.append("DefaultAvailabilityZone: ").append(this.getDefaultAvailabilityZone()).append(",");
        }
        if (this.getDefaultSubnetId() != null) {
            sb.append("DefaultSubnetId: ").append(this.getDefaultSubnetId()).append(",");
        }
        if (this.getCustomJson() != null) {
            sb.append("CustomJson: ").append(this.getCustomJson()).append(",");
        }
        if (this.getConfigurationManager() != null) {
            sb.append("ConfigurationManager: ").append(this.getConfigurationManager()).append(",");
        }
        if (this.getChefConfiguration() != null) {
            sb.append("ChefConfiguration: ").append(this.getChefConfiguration()).append(",");
        }
        if (this.getUseCustomCookbooks() != null) {
            sb.append("UseCustomCookbooks: ").append(this.getUseCustomCookbooks()).append(",");
        }
        if (this.getUseOpsworksSecurityGroups() != null) {
            sb.append("UseOpsworksSecurityGroups: ").append(this.getUseOpsworksSecurityGroups()).append(",");
        }
        if (this.getCustomCookbooksSource() != null) {
            sb.append("CustomCookbooksSource: ").append(this.getCustomCookbooksSource()).append(",");
        }
        if (this.getDefaultSshKeyName() != null) {
            sb.append("DefaultSshKeyName: ").append(this.getDefaultSshKeyName()).append(",");
        }
        if (this.getCreatedAt() != null) {
            sb.append("CreatedAt: ").append(this.getCreatedAt()).append(",");
        }
        if (this.getDefaultRootDeviceType() != null) {
            sb.append("DefaultRootDeviceType: ").append(this.getDefaultRootDeviceType()).append(",");
        }
        if (this.getAgentVersion() != null) {
            sb.append("AgentVersion: ").append(this.getAgentVersion());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Stack)) {
            return false;
        }
        Stack other = (Stack)obj;
        if (other.getStackId() == null ^ this.getStackId() == null) {
            return false;
        }
        if (other.getStackId() != null && !other.getStackId().equals(this.getStackId())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        if (other.getArn() != null && !other.getArn().equals(this.getArn())) {
            return false;
        }
        if (other.getRegion() == null ^ this.getRegion() == null) {
            return false;
        }
        if (other.getRegion() != null && !other.getRegion().equals(this.getRegion())) {
            return false;
        }
        if (other.getVpcId() == null ^ this.getVpcId() == null) {
            return false;
        }
        if (other.getVpcId() != null && !other.getVpcId().equals(this.getVpcId())) {
            return false;
        }
        if (other.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        if (other.getAttributes() != null && !other.getAttributes().equals(this.getAttributes())) {
            return false;
        }
        if (other.getServiceRoleArn() == null ^ this.getServiceRoleArn() == null) {
            return false;
        }
        if (other.getServiceRoleArn() != null && !other.getServiceRoleArn().equals(this.getServiceRoleArn())) {
            return false;
        }
        if (other.getDefaultInstanceProfileArn() == null ^ this.getDefaultInstanceProfileArn() == null) {
            return false;
        }
        if (other.getDefaultInstanceProfileArn() != null && !other.getDefaultInstanceProfileArn().equals(this.getDefaultInstanceProfileArn())) {
            return false;
        }
        if (other.getDefaultOs() == null ^ this.getDefaultOs() == null) {
            return false;
        }
        if (other.getDefaultOs() != null && !other.getDefaultOs().equals(this.getDefaultOs())) {
            return false;
        }
        if (other.getHostnameTheme() == null ^ this.getHostnameTheme() == null) {
            return false;
        }
        if (other.getHostnameTheme() != null && !other.getHostnameTheme().equals(this.getHostnameTheme())) {
            return false;
        }
        if (other.getDefaultAvailabilityZone() == null ^ this.getDefaultAvailabilityZone() == null) {
            return false;
        }
        if (other.getDefaultAvailabilityZone() != null && !other.getDefaultAvailabilityZone().equals(this.getDefaultAvailabilityZone())) {
            return false;
        }
        if (other.getDefaultSubnetId() == null ^ this.getDefaultSubnetId() == null) {
            return false;
        }
        if (other.getDefaultSubnetId() != null && !other.getDefaultSubnetId().equals(this.getDefaultSubnetId())) {
            return false;
        }
        if (other.getCustomJson() == null ^ this.getCustomJson() == null) {
            return false;
        }
        if (other.getCustomJson() != null && !other.getCustomJson().equals(this.getCustomJson())) {
            return false;
        }
        if (other.getConfigurationManager() == null ^ this.getConfigurationManager() == null) {
            return false;
        }
        if (other.getConfigurationManager() != null && !other.getConfigurationManager().equals(this.getConfigurationManager())) {
            return false;
        }
        if (other.getChefConfiguration() == null ^ this.getChefConfiguration() == null) {
            return false;
        }
        if (other.getChefConfiguration() != null && !other.getChefConfiguration().equals(this.getChefConfiguration())) {
            return false;
        }
        if (other.getUseCustomCookbooks() == null ^ this.getUseCustomCookbooks() == null) {
            return false;
        }
        if (other.getUseCustomCookbooks() != null && !other.getUseCustomCookbooks().equals(this.getUseCustomCookbooks())) {
            return false;
        }
        if (other.getUseOpsworksSecurityGroups() == null ^ this.getUseOpsworksSecurityGroups() == null) {
            return false;
        }
        if (other.getUseOpsworksSecurityGroups() != null && !other.getUseOpsworksSecurityGroups().equals(this.getUseOpsworksSecurityGroups())) {
            return false;
        }
        if (other.getCustomCookbooksSource() == null ^ this.getCustomCookbooksSource() == null) {
            return false;
        }
        if (other.getCustomCookbooksSource() != null && !other.getCustomCookbooksSource().equals(this.getCustomCookbooksSource())) {
            return false;
        }
        if (other.getDefaultSshKeyName() == null ^ this.getDefaultSshKeyName() == null) {
            return false;
        }
        if (other.getDefaultSshKeyName() != null && !other.getDefaultSshKeyName().equals(this.getDefaultSshKeyName())) {
            return false;
        }
        if (other.getCreatedAt() == null ^ this.getCreatedAt() == null) {
            return false;
        }
        if (other.getCreatedAt() != null && !other.getCreatedAt().equals(this.getCreatedAt())) {
            return false;
        }
        if (other.getDefaultRootDeviceType() == null ^ this.getDefaultRootDeviceType() == null) {
            return false;
        }
        if (other.getDefaultRootDeviceType() != null && !other.getDefaultRootDeviceType().equals(this.getDefaultRootDeviceType())) {
            return false;
        }
        if (other.getAgentVersion() == null ^ this.getAgentVersion() == null) {
            return false;
        }
        return other.getAgentVersion() == null || other.getAgentVersion().equals(this.getAgentVersion());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStackId() == null ? 0 : this.getStackId().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        hashCode = 31 * hashCode + (this.getRegion() == null ? 0 : this.getRegion().hashCode());
        hashCode = 31 * hashCode + (this.getVpcId() == null ? 0 : this.getVpcId().hashCode());
        hashCode = 31 * hashCode + (this.getAttributes() == null ? 0 : this.getAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getServiceRoleArn() == null ? 0 : this.getServiceRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultInstanceProfileArn() == null ? 0 : this.getDefaultInstanceProfileArn().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultOs() == null ? 0 : this.getDefaultOs().hashCode());
        hashCode = 31 * hashCode + (this.getHostnameTheme() == null ? 0 : this.getHostnameTheme().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultAvailabilityZone() == null ? 0 : this.getDefaultAvailabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultSubnetId() == null ? 0 : this.getDefaultSubnetId().hashCode());
        hashCode = 31 * hashCode + (this.getCustomJson() == null ? 0 : this.getCustomJson().hashCode());
        hashCode = 31 * hashCode + (this.getConfigurationManager() == null ? 0 : this.getConfigurationManager().hashCode());
        hashCode = 31 * hashCode + (this.getChefConfiguration() == null ? 0 : this.getChefConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getUseCustomCookbooks() == null ? 0 : this.getUseCustomCookbooks().hashCode());
        hashCode = 31 * hashCode + (this.getUseOpsworksSecurityGroups() == null ? 0 : this.getUseOpsworksSecurityGroups().hashCode());
        hashCode = 31 * hashCode + (this.getCustomCookbooksSource() == null ? 0 : this.getCustomCookbooksSource().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultSshKeyName() == null ? 0 : this.getDefaultSshKeyName().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedAt() == null ? 0 : this.getCreatedAt().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultRootDeviceType() == null ? 0 : this.getDefaultRootDeviceType().hashCode());
        hashCode = 31 * hashCode + (this.getAgentVersion() == null ? 0 : this.getAgentVersion().hashCode());
        return hashCode;
    }

    public Stack clone() {
        try {
            return (Stack)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StackMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

