/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticfilesystem.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.elasticfilesystem.model.FileSystemSize;
import java.util.Date;

@SdkInternalApi
public class FileSystemSizeMarshaller {
    private static final MarshallingInfo<Long> VALUE_BINDING = MarshallingInfo.builder(MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Value").build();
    private static final MarshallingInfo<Date> TIMESTAMP_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Timestamp").build();
    private static final FileSystemSizeMarshaller instance = new FileSystemSizeMarshaller();

    public static FileSystemSizeMarshaller getInstance() {
        return instance;
    }

    public void marshall(FileSystemSize fileSystemSize, ProtocolMarshaller protocolMarshaller) {
        if (fileSystemSize == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(fileSystemSize.getValue(), VALUE_BINDING);
            protocolMarshaller.marshall(fileSystemSize.getTimestamp(), TIMESTAMP_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

