/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.athena.model.transform;

import com.amazonaws.services.athena.model.Datum;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class DatumJsonUnmarshaller
implements Unmarshaller<Datum, JsonUnmarshallerContext> {
    private static DatumJsonUnmarshaller instance;

    @Override
    public Datum unmarshall(JsonUnmarshallerContext context) throws Exception {
        Datum datum = new Datum();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("VarCharValue", targetDepth)) {
                    context.nextToken();
                    datum.setVarCharValue(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return datum;
    }

    public static DatumJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new DatumJsonUnmarshaller();
        }
        return instance;
    }
}

