/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.autoscaling.model.DeletePolicyRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DeletePolicyRequestMarshaller
implements Marshaller<Request<DeletePolicyRequest>, DeletePolicyRequest> {
    @Override
    public Request<DeletePolicyRequest> marshall(DeletePolicyRequest deletePolicyRequest) {
        if (deletePolicyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeletePolicyRequest> request = new DefaultRequest<DeletePolicyRequest>(deletePolicyRequest, "AmazonAutoScaling");
        request.addParameter("Action", "DeletePolicy");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (deletePolicyRequest.getAutoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString(deletePolicyRequest.getAutoScalingGroupName()));
        }
        if (deletePolicyRequest.getPolicyName() != null) {
            request.addParameter("PolicyName", StringUtils.fromString(deletePolicyRequest.getPolicyName()));
        }
        return request;
    }
}

