/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.ecs.model.LoadBalancer;

@SdkInternalApi
public class LoadBalancerMarshaller {
    private static final MarshallingInfo<String> TARGETGROUPARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("targetGroupArn").build();
    private static final MarshallingInfo<String> LOADBALANCERNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("loadBalancerName").build();
    private static final MarshallingInfo<String> CONTAINERNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("containerName").build();
    private static final MarshallingInfo<Integer> CONTAINERPORT_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("containerPort").build();
    private static final LoadBalancerMarshaller instance = new LoadBalancerMarshaller();

    public static LoadBalancerMarshaller getInstance() {
        return instance;
    }

    public void marshall(LoadBalancer loadBalancer, ProtocolMarshaller protocolMarshaller) {
        if (loadBalancer == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(loadBalancer.getTargetGroupArn(), TARGETGROUPARN_BINDING);
            protocolMarshaller.marshall(loadBalancer.getLoadBalancerName(), LOADBALANCERNAME_BINDING);
            protocolMarshaller.marshall(loadBalancer.getContainerName(), CONTAINERNAME_BINDING);
            protocolMarshaller.marshall(loadBalancer.getContainerPort(), CONTAINERPORT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

