/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.machinelearning.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.machinelearning.model.TaggableResourceType;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class DeleteTagsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private SdkInternalList<String> tagKeys;
    private String resourceId;
    private String resourceType;

    public List<String> getTagKeys() {
        if (this.tagKeys == null) {
            this.tagKeys = new SdkInternalList();
        }
        return this.tagKeys;
    }

    public void setTagKeys(Collection<String> tagKeys) {
        if (tagKeys == null) {
            this.tagKeys = null;
            return;
        }
        this.tagKeys = new SdkInternalList<String>(tagKeys);
    }

    public DeleteTagsRequest withTagKeys(String ... tagKeys) {
        if (this.tagKeys == null) {
            this.setTagKeys(new SdkInternalList<String>(tagKeys.length));
        }
        for (String ele : tagKeys) {
            this.tagKeys.add(ele);
        }
        return this;
    }

    public DeleteTagsRequest withTagKeys(Collection<String> tagKeys) {
        this.setTagKeys(tagKeys);
        return this;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public DeleteTagsRequest withResourceId(String resourceId) {
        this.setResourceId(resourceId);
        return this;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public DeleteTagsRequest withResourceType(String resourceType) {
        this.setResourceType(resourceType);
        return this;
    }

    public void setResourceType(TaggableResourceType resourceType) {
        this.resourceType = resourceType.toString();
    }

    public DeleteTagsRequest withResourceType(TaggableResourceType resourceType) {
        this.setResourceType(resourceType);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTagKeys() != null) {
            sb.append("TagKeys: " + this.getTagKeys() + ",");
        }
        if (this.getResourceId() != null) {
            sb.append("ResourceId: " + this.getResourceId() + ",");
        }
        if (this.getResourceType() != null) {
            sb.append("ResourceType: " + this.getResourceType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteTagsRequest)) {
            return false;
        }
        DeleteTagsRequest other = (DeleteTagsRequest)obj;
        if (other.getTagKeys() == null ^ this.getTagKeys() == null) {
            return false;
        }
        if (other.getTagKeys() != null && !other.getTagKeys().equals(this.getTagKeys())) {
            return false;
        }
        if (other.getResourceId() == null ^ this.getResourceId() == null) {
            return false;
        }
        if (other.getResourceId() != null && !other.getResourceId().equals(this.getResourceId())) {
            return false;
        }
        if (other.getResourceType() == null ^ this.getResourceType() == null) {
            return false;
        }
        return other.getResourceType() == null || other.getResourceType().equals(this.getResourceType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTagKeys() == null ? 0 : this.getTagKeys().hashCode());
        hashCode = 31 * hashCode + (this.getResourceId() == null ? 0 : this.getResourceId().hashCode());
        hashCode = 31 * hashCode + (this.getResourceType() == null ? 0 : this.getResourceType().hashCode());
        return hashCode;
    }

    @Override
    public DeleteTagsRequest clone() {
        return (DeleteTagsRequest)super.clone();
    }
}

