/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAutoGenerateStrategy;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAutoGenerated;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAutoGenerator;
import com.amazonaws.services.dynamodbv2.datamodeling.StandardTypeConverters;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@DynamoDBAutoGenerated(generator=Generator.class)
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.FIELD, ElementType.METHOD})
public @interface DynamoDBAutoGeneratedDefault {
    public String value();

    public static final class Generator<T>
    implements DynamoDBAutoGenerator<T> {
        private final StandardTypeConverters.ConvertTo<String, T> converter;
        private final String defaultValue;

        public Generator(Class<T> targetType, DynamoDBAutoGeneratedDefault annotation) {
            this.converter = StandardTypeConverters.Scalar.STRING.to(targetType, false);
            this.defaultValue = annotation.value();
        }

        @Override
        public final DynamoDBAutoGenerateStrategy getGenerateStrategy() {
            return DynamoDBAutoGenerateStrategy.CREATE;
        }

        @Override
        public final T generate(T currentValue) {
            return this.converter.convertTo(this.defaultValue);
        }
    }
}

