/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iot.model.Action;
import com.amazonaws.services.iot.model.transform.TopicRuleMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class TopicRule
implements Serializable,
Cloneable,
StructuredPojo {
    private String ruleName;
    private String sql;
    private String description;
    private Date createdAt;
    private List<Action> actions;
    private Boolean ruleDisabled;
    private String awsIotSqlVersion;

    public void setRuleName(String ruleName) {
        this.ruleName = ruleName;
    }

    public String getRuleName() {
        return this.ruleName;
    }

    public TopicRule withRuleName(String ruleName) {
        this.setRuleName(ruleName);
        return this;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public String getSql() {
        return this.sql;
    }

    public TopicRule withSql(String sql) {
        this.setSql(sql);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public TopicRule withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public TopicRule withCreatedAt(Date createdAt) {
        this.setCreatedAt(createdAt);
        return this;
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public void setActions(Collection<Action> actions) {
        if (actions == null) {
            this.actions = null;
            return;
        }
        this.actions = new ArrayList<Action>(actions);
    }

    public TopicRule withActions(Action ... actions) {
        if (this.actions == null) {
            this.setActions(new ArrayList<Action>(actions.length));
        }
        for (Action ele : actions) {
            this.actions.add(ele);
        }
        return this;
    }

    public TopicRule withActions(Collection<Action> actions) {
        this.setActions(actions);
        return this;
    }

    public void setRuleDisabled(Boolean ruleDisabled) {
        this.ruleDisabled = ruleDisabled;
    }

    public Boolean getRuleDisabled() {
        return this.ruleDisabled;
    }

    public TopicRule withRuleDisabled(Boolean ruleDisabled) {
        this.setRuleDisabled(ruleDisabled);
        return this;
    }

    public Boolean isRuleDisabled() {
        return this.ruleDisabled;
    }

    public void setAwsIotSqlVersion(String awsIotSqlVersion) {
        this.awsIotSqlVersion = awsIotSqlVersion;
    }

    public String getAwsIotSqlVersion() {
        return this.awsIotSqlVersion;
    }

    public TopicRule withAwsIotSqlVersion(String awsIotSqlVersion) {
        this.setAwsIotSqlVersion(awsIotSqlVersion);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRuleName() != null) {
            sb.append("RuleName: ").append(this.getRuleName()).append(",");
        }
        if (this.getSql() != null) {
            sb.append("Sql: ").append(this.getSql()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getCreatedAt() != null) {
            sb.append("CreatedAt: ").append(this.getCreatedAt()).append(",");
        }
        if (this.getActions() != null) {
            sb.append("Actions: ").append(this.getActions()).append(",");
        }
        if (this.getRuleDisabled() != null) {
            sb.append("RuleDisabled: ").append(this.getRuleDisabled()).append(",");
        }
        if (this.getAwsIotSqlVersion() != null) {
            sb.append("AwsIotSqlVersion: ").append(this.getAwsIotSqlVersion());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicRule)) {
            return false;
        }
        TopicRule other = (TopicRule)obj;
        if (other.getRuleName() == null ^ this.getRuleName() == null) {
            return false;
        }
        if (other.getRuleName() != null && !other.getRuleName().equals(this.getRuleName())) {
            return false;
        }
        if (other.getSql() == null ^ this.getSql() == null) {
            return false;
        }
        if (other.getSql() != null && !other.getSql().equals(this.getSql())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getCreatedAt() == null ^ this.getCreatedAt() == null) {
            return false;
        }
        if (other.getCreatedAt() != null && !other.getCreatedAt().equals(this.getCreatedAt())) {
            return false;
        }
        if (other.getActions() == null ^ this.getActions() == null) {
            return false;
        }
        if (other.getActions() != null && !other.getActions().equals(this.getActions())) {
            return false;
        }
        if (other.getRuleDisabled() == null ^ this.getRuleDisabled() == null) {
            return false;
        }
        if (other.getRuleDisabled() != null && !other.getRuleDisabled().equals(this.getRuleDisabled())) {
            return false;
        }
        if (other.getAwsIotSqlVersion() == null ^ this.getAwsIotSqlVersion() == null) {
            return false;
        }
        return other.getAwsIotSqlVersion() == null || other.getAwsIotSqlVersion().equals(this.getAwsIotSqlVersion());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRuleName() == null ? 0 : this.getRuleName().hashCode());
        hashCode = 31 * hashCode + (this.getSql() == null ? 0 : this.getSql().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedAt() == null ? 0 : this.getCreatedAt().hashCode());
        hashCode = 31 * hashCode + (this.getActions() == null ? 0 : this.getActions().hashCode());
        hashCode = 31 * hashCode + (this.getRuleDisabled() == null ? 0 : this.getRuleDisabled().hashCode());
        hashCode = 31 * hashCode + (this.getAwsIotSqlVersion() == null ? 0 : this.getAwsIotSqlVersion().hashCode());
        return hashCode;
    }

    public TopicRule clone() {
        try {
            return (TopicRule)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TopicRuleMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

