/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ecs.model.PlacementConstraint;
import com.amazonaws.services.ecs.model.PlacementStrategy;
import com.amazonaws.services.ecs.model.TaskOverride;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class RunTaskRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String cluster;
    private String taskDefinition;
    private TaskOverride overrides;
    private Integer count;
    private String startedBy;
    private String group;
    private SdkInternalList<PlacementConstraint> placementConstraints;
    private SdkInternalList<PlacementStrategy> placementStrategy;

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public String getCluster() {
        return this.cluster;
    }

    public RunTaskRequest withCluster(String cluster) {
        this.setCluster(cluster);
        return this;
    }

    public void setTaskDefinition(String taskDefinition) {
        this.taskDefinition = taskDefinition;
    }

    public String getTaskDefinition() {
        return this.taskDefinition;
    }

    public RunTaskRequest withTaskDefinition(String taskDefinition) {
        this.setTaskDefinition(taskDefinition);
        return this;
    }

    public void setOverrides(TaskOverride overrides) {
        this.overrides = overrides;
    }

    public TaskOverride getOverrides() {
        return this.overrides;
    }

    public RunTaskRequest withOverrides(TaskOverride overrides) {
        this.setOverrides(overrides);
        return this;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public Integer getCount() {
        return this.count;
    }

    public RunTaskRequest withCount(Integer count) {
        this.setCount(count);
        return this;
    }

    public void setStartedBy(String startedBy) {
        this.startedBy = startedBy;
    }

    public String getStartedBy() {
        return this.startedBy;
    }

    public RunTaskRequest withStartedBy(String startedBy) {
        this.setStartedBy(startedBy);
        return this;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getGroup() {
        return this.group;
    }

    public RunTaskRequest withGroup(String group) {
        this.setGroup(group);
        return this;
    }

    public List<PlacementConstraint> getPlacementConstraints() {
        if (this.placementConstraints == null) {
            this.placementConstraints = new SdkInternalList();
        }
        return this.placementConstraints;
    }

    public void setPlacementConstraints(Collection<PlacementConstraint> placementConstraints) {
        if (placementConstraints == null) {
            this.placementConstraints = null;
            return;
        }
        this.placementConstraints = new SdkInternalList<PlacementConstraint>(placementConstraints);
    }

    public RunTaskRequest withPlacementConstraints(PlacementConstraint ... placementConstraints) {
        if (this.placementConstraints == null) {
            this.setPlacementConstraints(new SdkInternalList<PlacementConstraint>(placementConstraints.length));
        }
        for (PlacementConstraint ele : placementConstraints) {
            this.placementConstraints.add(ele);
        }
        return this;
    }

    public RunTaskRequest withPlacementConstraints(Collection<PlacementConstraint> placementConstraints) {
        this.setPlacementConstraints(placementConstraints);
        return this;
    }

    public List<PlacementStrategy> getPlacementStrategy() {
        if (this.placementStrategy == null) {
            this.placementStrategy = new SdkInternalList();
        }
        return this.placementStrategy;
    }

    public void setPlacementStrategy(Collection<PlacementStrategy> placementStrategy) {
        if (placementStrategy == null) {
            this.placementStrategy = null;
            return;
        }
        this.placementStrategy = new SdkInternalList<PlacementStrategy>(placementStrategy);
    }

    public RunTaskRequest withPlacementStrategy(PlacementStrategy ... placementStrategy) {
        if (this.placementStrategy == null) {
            this.setPlacementStrategy(new SdkInternalList<PlacementStrategy>(placementStrategy.length));
        }
        for (PlacementStrategy ele : placementStrategy) {
            this.placementStrategy.add(ele);
        }
        return this;
    }

    public RunTaskRequest withPlacementStrategy(Collection<PlacementStrategy> placementStrategy) {
        this.setPlacementStrategy(placementStrategy);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCluster() != null) {
            sb.append("Cluster: ").append(this.getCluster()).append(",");
        }
        if (this.getTaskDefinition() != null) {
            sb.append("TaskDefinition: ").append(this.getTaskDefinition()).append(",");
        }
        if (this.getOverrides() != null) {
            sb.append("Overrides: ").append(this.getOverrides()).append(",");
        }
        if (this.getCount() != null) {
            sb.append("Count: ").append(this.getCount()).append(",");
        }
        if (this.getStartedBy() != null) {
            sb.append("StartedBy: ").append(this.getStartedBy()).append(",");
        }
        if (this.getGroup() != null) {
            sb.append("Group: ").append(this.getGroup()).append(",");
        }
        if (this.getPlacementConstraints() != null) {
            sb.append("PlacementConstraints: ").append(this.getPlacementConstraints()).append(",");
        }
        if (this.getPlacementStrategy() != null) {
            sb.append("PlacementStrategy: ").append(this.getPlacementStrategy());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RunTaskRequest)) {
            return false;
        }
        RunTaskRequest other = (RunTaskRequest)obj;
        if (other.getCluster() == null ^ this.getCluster() == null) {
            return false;
        }
        if (other.getCluster() != null && !other.getCluster().equals(this.getCluster())) {
            return false;
        }
        if (other.getTaskDefinition() == null ^ this.getTaskDefinition() == null) {
            return false;
        }
        if (other.getTaskDefinition() != null && !other.getTaskDefinition().equals(this.getTaskDefinition())) {
            return false;
        }
        if (other.getOverrides() == null ^ this.getOverrides() == null) {
            return false;
        }
        if (other.getOverrides() != null && !other.getOverrides().equals(this.getOverrides())) {
            return false;
        }
        if (other.getCount() == null ^ this.getCount() == null) {
            return false;
        }
        if (other.getCount() != null && !other.getCount().equals(this.getCount())) {
            return false;
        }
        if (other.getStartedBy() == null ^ this.getStartedBy() == null) {
            return false;
        }
        if (other.getStartedBy() != null && !other.getStartedBy().equals(this.getStartedBy())) {
            return false;
        }
        if (other.getGroup() == null ^ this.getGroup() == null) {
            return false;
        }
        if (other.getGroup() != null && !other.getGroup().equals(this.getGroup())) {
            return false;
        }
        if (other.getPlacementConstraints() == null ^ this.getPlacementConstraints() == null) {
            return false;
        }
        if (other.getPlacementConstraints() != null && !other.getPlacementConstraints().equals(this.getPlacementConstraints())) {
            return false;
        }
        if (other.getPlacementStrategy() == null ^ this.getPlacementStrategy() == null) {
            return false;
        }
        return other.getPlacementStrategy() == null || other.getPlacementStrategy().equals(this.getPlacementStrategy());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCluster() == null ? 0 : this.getCluster().hashCode());
        hashCode = 31 * hashCode + (this.getTaskDefinition() == null ? 0 : this.getTaskDefinition().hashCode());
        hashCode = 31 * hashCode + (this.getOverrides() == null ? 0 : this.getOverrides().hashCode());
        hashCode = 31 * hashCode + (this.getCount() == null ? 0 : this.getCount().hashCode());
        hashCode = 31 * hashCode + (this.getStartedBy() == null ? 0 : this.getStartedBy().hashCode());
        hashCode = 31 * hashCode + (this.getGroup() == null ? 0 : this.getGroup().hashCode());
        hashCode = 31 * hashCode + (this.getPlacementConstraints() == null ? 0 : this.getPlacementConstraints().hashCode());
        hashCode = 31 * hashCode + (this.getPlacementStrategy() == null ? 0 : this.getPlacementStrategy().hashCode());
        return hashCode;
    }

    @Override
    public RunTaskRequest clone() {
        return (RunTaskRequest)super.clone();
    }
}

