/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.opsworks.model.ChefConfiguration;

@SdkInternalApi
public class ChefConfigurationMarshaller {
    private static final MarshallingInfo<Boolean> MANAGEBERKSHELF_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ManageBerkshelf").build();
    private static final MarshallingInfo<String> BERKSHELFVERSION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BerkshelfVersion").build();
    private static final ChefConfigurationMarshaller instance = new ChefConfigurationMarshaller();

    public static ChefConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(ChefConfiguration chefConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (chefConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(chefConfiguration.getManageBerkshelf(), MANAGEBERKSHELF_BINDING);
            protocolMarshaller.marshall(chefConfiguration.getBerkshelfVersion(), BERKSHELFVERSION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

