/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53.model.transform;

import com.amazonaws.services.route53.model.DelegationSet;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class DelegationSetStaxUnmarshaller
implements Unmarshaller<DelegationSet, StaxUnmarshallerContext> {
    private static DelegationSetStaxUnmarshaller instance;

    @Override
    public DelegationSet unmarshall(StaxUnmarshallerContext context) throws Exception {
        DelegationSet delegationSet = new DelegationSet();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return delegationSet;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Id", targetDepth)) {
                    delegationSet.setId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CallerReference", targetDepth)) {
                    delegationSet.setCallerReference(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("NameServers/NameServer", targetDepth)) continue;
                delegationSet.withNameServers(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return delegationSet;
    }

    public static DelegationSetStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new DelegationSetStaxUnmarshaller();
        }
        return instance;
    }
}

