/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directconnect.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.directconnect.model.DeleteConnectionRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class DeleteConnectionRequestMarshaller
implements Marshaller<Request<DeleteConnectionRequest>, DeleteConnectionRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DeleteConnectionRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DeleteConnectionRequest> marshall(DeleteConnectionRequest deleteConnectionRequest) {
        if (deleteConnectionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteConnectionRequest> request = new DefaultRequest<DeleteConnectionRequest>(deleteConnectionRequest, "AmazonDirectConnect");
        request.addHeader("X-Amz-Target", "OvertureService.DeleteConnection");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (deleteConnectionRequest.getConnectionId() != null) {
                jsonGenerator.writeFieldName("connectionId").writeValue(deleteConnectionRequest.getConnectionId());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

