/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lexruntime.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.lexruntime.model.ResponseCard;
import java.util.List;

@SdkInternalApi
public class ResponseCardMarshaller {
    private static final MarshallingInfo<String> VERSION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("version").build();
    private static final MarshallingInfo<String> CONTENTTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("contentType").build();
    private static final MarshallingInfo<List> GENERICATTACHMENTS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("genericAttachments").build();
    private static final ResponseCardMarshaller instance = new ResponseCardMarshaller();

    public static ResponseCardMarshaller getInstance() {
        return instance;
    }

    public void marshall(ResponseCard responseCard, ProtocolMarshaller protocolMarshaller) {
        if (responseCard == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(responseCard.getVersion(), VERSION_BINDING);
            protocolMarshaller.marshall(responseCard.getContentType(), CONTENTTYPE_BINDING);
            protocolMarshaller.marshall(responseCard.getGenericAttachments(), GENERICATTACHMENTS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

