/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeReservedInstancesRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeReservedInstancesRequestMarshaller
implements Marshaller<Request<DescribeReservedInstancesRequest>, DescribeReservedInstancesRequest> {
    @Override
    public Request<DescribeReservedInstancesRequest> marshall(DescribeReservedInstancesRequest describeReservedInstancesRequest) {
        SdkInternalList describeReservedInstancesRequestFiltersList;
        if (describeReservedInstancesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeReservedInstancesRequest> request = new DefaultRequest<DescribeReservedInstancesRequest>(describeReservedInstancesRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeReservedInstances");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeReservedInstancesRequestReservedInstancesIdsList = (SdkInternalList)describeReservedInstancesRequest.getReservedInstancesIds();
        if (!describeReservedInstancesRequestReservedInstancesIdsList.isEmpty() || !describeReservedInstancesRequestReservedInstancesIdsList.isAutoConstruct()) {
            int reservedInstancesIdsListIndex = 1;
            for (String describeReservedInstancesRequestReservedInstancesIdsListValue : describeReservedInstancesRequestReservedInstancesIdsList) {
                if (describeReservedInstancesRequestReservedInstancesIdsListValue != null) {
                    request.addParameter("ReservedInstancesId." + reservedInstancesIdsListIndex, StringUtils.fromString(describeReservedInstancesRequestReservedInstancesIdsListValue));
                }
                ++reservedInstancesIdsListIndex;
            }
        }
        if (!(describeReservedInstancesRequestFiltersList = (SdkInternalList)describeReservedInstancesRequest.getFilters()).isEmpty() || !describeReservedInstancesRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeReservedInstancesRequestFiltersListValue : describeReservedInstancesRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeReservedInstancesRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString(describeReservedInstancesRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describeReservedInstancesRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString(filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeReservedInstancesRequest.getOfferingType() != null) {
            request.addParameter("OfferingType", StringUtils.fromString(describeReservedInstancesRequest.getOfferingType()));
        }
        if (describeReservedInstancesRequest.getOfferingClass() != null) {
            request.addParameter("OfferingClass", StringUtils.fromString(describeReservedInstancesRequest.getOfferingClass()));
        }
        return request;
    }
}

