/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.ArchitectureValues;
import com.amazonaws.services.ec2.model.BlockDeviceMapping;
import com.amazonaws.services.ec2.model.DeviceType;
import com.amazonaws.services.ec2.model.HypervisorType;
import com.amazonaws.services.ec2.model.ImageState;
import com.amazonaws.services.ec2.model.ImageTypeValues;
import com.amazonaws.services.ec2.model.PlatformValues;
import com.amazonaws.services.ec2.model.ProductCode;
import com.amazonaws.services.ec2.model.StateReason;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.VirtualizationType;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class Image
implements Serializable,
Cloneable {
    private String imageId;
    private String imageLocation;
    private String state;
    private String ownerId;
    private String creationDate;
    private Boolean publicValue;
    private SdkInternalList<ProductCode> productCodes;
    private String architecture;
    private String imageType;
    private String kernelId;
    private String ramdiskId;
    private String platform;
    private String sriovNetSupport;
    private Boolean enaSupport;
    private StateReason stateReason;
    private String imageOwnerAlias;
    private String name;
    private String description;
    private String rootDeviceType;
    private String rootDeviceName;
    private SdkInternalList<BlockDeviceMapping> blockDeviceMappings;
    private String virtualizationType;
    private SdkInternalList<Tag> tags;
    private String hypervisor;

    public void setImageId(String imageId) {
        this.imageId = imageId;
    }

    public String getImageId() {
        return this.imageId;
    }

    public Image withImageId(String imageId) {
        this.setImageId(imageId);
        return this;
    }

    public void setImageLocation(String imageLocation) {
        this.imageLocation = imageLocation;
    }

    public String getImageLocation() {
        return this.imageLocation;
    }

    public Image withImageLocation(String imageLocation) {
        this.setImageLocation(imageLocation);
        return this;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getState() {
        return this.state;
    }

    public Image withState(String state) {
        this.setState(state);
        return this;
    }

    public void setState(ImageState state) {
        this.state = state.toString();
    }

    public Image withState(ImageState state) {
        this.setState(state);
        return this;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public Image withOwnerId(String ownerId) {
        this.setOwnerId(ownerId);
        return this;
    }

    public void setCreationDate(String creationDate) {
        this.creationDate = creationDate;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    public Image withCreationDate(String creationDate) {
        this.setCreationDate(creationDate);
        return this;
    }

    public void setPublic(Boolean publicValue) {
        this.publicValue = publicValue;
    }

    public Boolean getPublic() {
        return this.publicValue;
    }

    public Image withPublic(Boolean publicValue) {
        this.setPublic(publicValue);
        return this;
    }

    public Boolean isPublic() {
        return this.publicValue;
    }

    public List<ProductCode> getProductCodes() {
        if (this.productCodes == null) {
            this.productCodes = new SdkInternalList();
        }
        return this.productCodes;
    }

    public void setProductCodes(Collection<ProductCode> productCodes) {
        if (productCodes == null) {
            this.productCodes = null;
            return;
        }
        this.productCodes = new SdkInternalList<ProductCode>(productCodes);
    }

    public Image withProductCodes(ProductCode ... productCodes) {
        if (this.productCodes == null) {
            this.setProductCodes(new SdkInternalList<ProductCode>(productCodes.length));
        }
        for (ProductCode ele : productCodes) {
            this.productCodes.add(ele);
        }
        return this;
    }

    public Image withProductCodes(Collection<ProductCode> productCodes) {
        this.setProductCodes(productCodes);
        return this;
    }

    public void setArchitecture(String architecture) {
        this.architecture = architecture;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public Image withArchitecture(String architecture) {
        this.setArchitecture(architecture);
        return this;
    }

    public void setArchitecture(ArchitectureValues architecture) {
        this.architecture = architecture.toString();
    }

    public Image withArchitecture(ArchitectureValues architecture) {
        this.setArchitecture(architecture);
        return this;
    }

    public void setImageType(String imageType) {
        this.imageType = imageType;
    }

    public String getImageType() {
        return this.imageType;
    }

    public Image withImageType(String imageType) {
        this.setImageType(imageType);
        return this;
    }

    public void setImageType(ImageTypeValues imageType) {
        this.imageType = imageType.toString();
    }

    public Image withImageType(ImageTypeValues imageType) {
        this.setImageType(imageType);
        return this;
    }

    public void setKernelId(String kernelId) {
        this.kernelId = kernelId;
    }

    public String getKernelId() {
        return this.kernelId;
    }

    public Image withKernelId(String kernelId) {
        this.setKernelId(kernelId);
        return this;
    }

    public void setRamdiskId(String ramdiskId) {
        this.ramdiskId = ramdiskId;
    }

    public String getRamdiskId() {
        return this.ramdiskId;
    }

    public Image withRamdiskId(String ramdiskId) {
        this.setRamdiskId(ramdiskId);
        return this;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getPlatform() {
        return this.platform;
    }

    public Image withPlatform(String platform) {
        this.setPlatform(platform);
        return this;
    }

    public void setPlatform(PlatformValues platform) {
        this.platform = platform.toString();
    }

    public Image withPlatform(PlatformValues platform) {
        this.setPlatform(platform);
        return this;
    }

    public void setSriovNetSupport(String sriovNetSupport) {
        this.sriovNetSupport = sriovNetSupport;
    }

    public String getSriovNetSupport() {
        return this.sriovNetSupport;
    }

    public Image withSriovNetSupport(String sriovNetSupport) {
        this.setSriovNetSupport(sriovNetSupport);
        return this;
    }

    public void setEnaSupport(Boolean enaSupport) {
        this.enaSupport = enaSupport;
    }

    public Boolean getEnaSupport() {
        return this.enaSupport;
    }

    public Image withEnaSupport(Boolean enaSupport) {
        this.setEnaSupport(enaSupport);
        return this;
    }

    public Boolean isEnaSupport() {
        return this.enaSupport;
    }

    public void setStateReason(StateReason stateReason) {
        this.stateReason = stateReason;
    }

    public StateReason getStateReason() {
        return this.stateReason;
    }

    public Image withStateReason(StateReason stateReason) {
        this.setStateReason(stateReason);
        return this;
    }

    public void setImageOwnerAlias(String imageOwnerAlias) {
        this.imageOwnerAlias = imageOwnerAlias;
    }

    public String getImageOwnerAlias() {
        return this.imageOwnerAlias;
    }

    public Image withImageOwnerAlias(String imageOwnerAlias) {
        this.setImageOwnerAlias(imageOwnerAlias);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Image withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public Image withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setRootDeviceType(String rootDeviceType) {
        this.rootDeviceType = rootDeviceType;
    }

    public String getRootDeviceType() {
        return this.rootDeviceType;
    }

    public Image withRootDeviceType(String rootDeviceType) {
        this.setRootDeviceType(rootDeviceType);
        return this;
    }

    public void setRootDeviceType(DeviceType rootDeviceType) {
        this.rootDeviceType = rootDeviceType.toString();
    }

    public Image withRootDeviceType(DeviceType rootDeviceType) {
        this.setRootDeviceType(rootDeviceType);
        return this;
    }

    public void setRootDeviceName(String rootDeviceName) {
        this.rootDeviceName = rootDeviceName;
    }

    public String getRootDeviceName() {
        return this.rootDeviceName;
    }

    public Image withRootDeviceName(String rootDeviceName) {
        this.setRootDeviceName(rootDeviceName);
        return this;
    }

    public List<BlockDeviceMapping> getBlockDeviceMappings() {
        if (this.blockDeviceMappings == null) {
            this.blockDeviceMappings = new SdkInternalList();
        }
        return this.blockDeviceMappings;
    }

    public void setBlockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
        if (blockDeviceMappings == null) {
            this.blockDeviceMappings = null;
            return;
        }
        this.blockDeviceMappings = new SdkInternalList<BlockDeviceMapping>(blockDeviceMappings);
    }

    public Image withBlockDeviceMappings(BlockDeviceMapping ... blockDeviceMappings) {
        if (this.blockDeviceMappings == null) {
            this.setBlockDeviceMappings(new SdkInternalList<BlockDeviceMapping>(blockDeviceMappings.length));
        }
        for (BlockDeviceMapping ele : blockDeviceMappings) {
            this.blockDeviceMappings.add(ele);
        }
        return this;
    }

    public Image withBlockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
        this.setBlockDeviceMappings(blockDeviceMappings);
        return this;
    }

    public void setVirtualizationType(String virtualizationType) {
        this.virtualizationType = virtualizationType;
    }

    public String getVirtualizationType() {
        return this.virtualizationType;
    }

    public Image withVirtualizationType(String virtualizationType) {
        this.setVirtualizationType(virtualizationType);
        return this;
    }

    public void setVirtualizationType(VirtualizationType virtualizationType) {
        this.virtualizationType = virtualizationType.toString();
    }

    public Image withVirtualizationType(VirtualizationType virtualizationType) {
        this.setVirtualizationType(virtualizationType);
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList<Tag>(tags);
    }

    public Image withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new SdkInternalList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public Image withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setHypervisor(String hypervisor) {
        this.hypervisor = hypervisor;
    }

    public String getHypervisor() {
        return this.hypervisor;
    }

    public Image withHypervisor(String hypervisor) {
        this.setHypervisor(hypervisor);
        return this;
    }

    public void setHypervisor(HypervisorType hypervisor) {
        this.hypervisor = hypervisor.toString();
    }

    public Image withHypervisor(HypervisorType hypervisor) {
        this.setHypervisor(hypervisor);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getImageId() != null) {
            sb.append("ImageId: ").append(this.getImageId()).append(",");
        }
        if (this.getImageLocation() != null) {
            sb.append("ImageLocation: ").append(this.getImageLocation()).append(",");
        }
        if (this.getState() != null) {
            sb.append("State: ").append(this.getState()).append(",");
        }
        if (this.getOwnerId() != null) {
            sb.append("OwnerId: ").append(this.getOwnerId()).append(",");
        }
        if (this.getCreationDate() != null) {
            sb.append("CreationDate: ").append(this.getCreationDate()).append(",");
        }
        if (this.getPublic() != null) {
            sb.append("Public: ").append(this.getPublic()).append(",");
        }
        if (this.getProductCodes() != null) {
            sb.append("ProductCodes: ").append(this.getProductCodes()).append(",");
        }
        if (this.getArchitecture() != null) {
            sb.append("Architecture: ").append(this.getArchitecture()).append(",");
        }
        if (this.getImageType() != null) {
            sb.append("ImageType: ").append(this.getImageType()).append(",");
        }
        if (this.getKernelId() != null) {
            sb.append("KernelId: ").append(this.getKernelId()).append(",");
        }
        if (this.getRamdiskId() != null) {
            sb.append("RamdiskId: ").append(this.getRamdiskId()).append(",");
        }
        if (this.getPlatform() != null) {
            sb.append("Platform: ").append(this.getPlatform()).append(",");
        }
        if (this.getSriovNetSupport() != null) {
            sb.append("SriovNetSupport: ").append(this.getSriovNetSupport()).append(",");
        }
        if (this.getEnaSupport() != null) {
            sb.append("EnaSupport: ").append(this.getEnaSupport()).append(",");
        }
        if (this.getStateReason() != null) {
            sb.append("StateReason: ").append(this.getStateReason()).append(",");
        }
        if (this.getImageOwnerAlias() != null) {
            sb.append("ImageOwnerAlias: ").append(this.getImageOwnerAlias()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getRootDeviceType() != null) {
            sb.append("RootDeviceType: ").append(this.getRootDeviceType()).append(",");
        }
        if (this.getRootDeviceName() != null) {
            sb.append("RootDeviceName: ").append(this.getRootDeviceName()).append(",");
        }
        if (this.getBlockDeviceMappings() != null) {
            sb.append("BlockDeviceMappings: ").append(this.getBlockDeviceMappings()).append(",");
        }
        if (this.getVirtualizationType() != null) {
            sb.append("VirtualizationType: ").append(this.getVirtualizationType()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getHypervisor() != null) {
            sb.append("Hypervisor: ").append(this.getHypervisor());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Image)) {
            return false;
        }
        Image other = (Image)obj;
        if (other.getImageId() == null ^ this.getImageId() == null) {
            return false;
        }
        if (other.getImageId() != null && !other.getImageId().equals(this.getImageId())) {
            return false;
        }
        if (other.getImageLocation() == null ^ this.getImageLocation() == null) {
            return false;
        }
        if (other.getImageLocation() != null && !other.getImageLocation().equals(this.getImageLocation())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getOwnerId() == null ^ this.getOwnerId() == null) {
            return false;
        }
        if (other.getOwnerId() != null && !other.getOwnerId().equals(this.getOwnerId())) {
            return false;
        }
        if (other.getCreationDate() == null ^ this.getCreationDate() == null) {
            return false;
        }
        if (other.getCreationDate() != null && !other.getCreationDate().equals(this.getCreationDate())) {
            return false;
        }
        if (other.getPublic() == null ^ this.getPublic() == null) {
            return false;
        }
        if (other.getPublic() != null && !other.getPublic().equals(this.getPublic())) {
            return false;
        }
        if (other.getProductCodes() == null ^ this.getProductCodes() == null) {
            return false;
        }
        if (other.getProductCodes() != null && !other.getProductCodes().equals(this.getProductCodes())) {
            return false;
        }
        if (other.getArchitecture() == null ^ this.getArchitecture() == null) {
            return false;
        }
        if (other.getArchitecture() != null && !other.getArchitecture().equals(this.getArchitecture())) {
            return false;
        }
        if (other.getImageType() == null ^ this.getImageType() == null) {
            return false;
        }
        if (other.getImageType() != null && !other.getImageType().equals(this.getImageType())) {
            return false;
        }
        if (other.getKernelId() == null ^ this.getKernelId() == null) {
            return false;
        }
        if (other.getKernelId() != null && !other.getKernelId().equals(this.getKernelId())) {
            return false;
        }
        if (other.getRamdiskId() == null ^ this.getRamdiskId() == null) {
            return false;
        }
        if (other.getRamdiskId() != null && !other.getRamdiskId().equals(this.getRamdiskId())) {
            return false;
        }
        if (other.getPlatform() == null ^ this.getPlatform() == null) {
            return false;
        }
        if (other.getPlatform() != null && !other.getPlatform().equals(this.getPlatform())) {
            return false;
        }
        if (other.getSriovNetSupport() == null ^ this.getSriovNetSupport() == null) {
            return false;
        }
        if (other.getSriovNetSupport() != null && !other.getSriovNetSupport().equals(this.getSriovNetSupport())) {
            return false;
        }
        if (other.getEnaSupport() == null ^ this.getEnaSupport() == null) {
            return false;
        }
        if (other.getEnaSupport() != null && !other.getEnaSupport().equals(this.getEnaSupport())) {
            return false;
        }
        if (other.getStateReason() == null ^ this.getStateReason() == null) {
            return false;
        }
        if (other.getStateReason() != null && !other.getStateReason().equals(this.getStateReason())) {
            return false;
        }
        if (other.getImageOwnerAlias() == null ^ this.getImageOwnerAlias() == null) {
            return false;
        }
        if (other.getImageOwnerAlias() != null && !other.getImageOwnerAlias().equals(this.getImageOwnerAlias())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getRootDeviceType() == null ^ this.getRootDeviceType() == null) {
            return false;
        }
        if (other.getRootDeviceType() != null && !other.getRootDeviceType().equals(this.getRootDeviceType())) {
            return false;
        }
        if (other.getRootDeviceName() == null ^ this.getRootDeviceName() == null) {
            return false;
        }
        if (other.getRootDeviceName() != null && !other.getRootDeviceName().equals(this.getRootDeviceName())) {
            return false;
        }
        if (other.getBlockDeviceMappings() == null ^ this.getBlockDeviceMappings() == null) {
            return false;
        }
        if (other.getBlockDeviceMappings() != null && !other.getBlockDeviceMappings().equals(this.getBlockDeviceMappings())) {
            return false;
        }
        if (other.getVirtualizationType() == null ^ this.getVirtualizationType() == null) {
            return false;
        }
        if (other.getVirtualizationType() != null && !other.getVirtualizationType().equals(this.getVirtualizationType())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getHypervisor() == null ^ this.getHypervisor() == null) {
            return false;
        }
        return other.getHypervisor() == null || other.getHypervisor().equals(this.getHypervisor());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getImageId() == null ? 0 : this.getImageId().hashCode());
        hashCode = 31 * hashCode + (this.getImageLocation() == null ? 0 : this.getImageLocation().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getOwnerId() == null ? 0 : this.getOwnerId().hashCode());
        hashCode = 31 * hashCode + (this.getCreationDate() == null ? 0 : this.getCreationDate().hashCode());
        hashCode = 31 * hashCode + (this.getPublic() == null ? 0 : this.getPublic().hashCode());
        hashCode = 31 * hashCode + (this.getProductCodes() == null ? 0 : this.getProductCodes().hashCode());
        hashCode = 31 * hashCode + (this.getArchitecture() == null ? 0 : this.getArchitecture().hashCode());
        hashCode = 31 * hashCode + (this.getImageType() == null ? 0 : this.getImageType().hashCode());
        hashCode = 31 * hashCode + (this.getKernelId() == null ? 0 : this.getKernelId().hashCode());
        hashCode = 31 * hashCode + (this.getRamdiskId() == null ? 0 : this.getRamdiskId().hashCode());
        hashCode = 31 * hashCode + (this.getPlatform() == null ? 0 : this.getPlatform().hashCode());
        hashCode = 31 * hashCode + (this.getSriovNetSupport() == null ? 0 : this.getSriovNetSupport().hashCode());
        hashCode = 31 * hashCode + (this.getEnaSupport() == null ? 0 : this.getEnaSupport().hashCode());
        hashCode = 31 * hashCode + (this.getStateReason() == null ? 0 : this.getStateReason().hashCode());
        hashCode = 31 * hashCode + (this.getImageOwnerAlias() == null ? 0 : this.getImageOwnerAlias().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getRootDeviceType() == null ? 0 : this.getRootDeviceType().hashCode());
        hashCode = 31 * hashCode + (this.getRootDeviceName() == null ? 0 : this.getRootDeviceName().hashCode());
        hashCode = 31 * hashCode + (this.getBlockDeviceMappings() == null ? 0 : this.getBlockDeviceMappings().hashCode());
        hashCode = 31 * hashCode + (this.getVirtualizationType() == null ? 0 : this.getVirtualizationType().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getHypervisor() == null ? 0 : this.getHypervisor().hashCode());
        return hashCode;
    }

    public Image clone() {
        try {
            return (Image)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

