/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancingv2.model.transform;

import com.amazonaws.services.elasticloadbalancingv2.model.Cipher;
import com.amazonaws.services.elasticloadbalancingv2.model.SslPolicy;
import com.amazonaws.services.elasticloadbalancingv2.model.transform.CipherStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class SslPolicyStaxUnmarshaller
implements Unmarshaller<SslPolicy, StaxUnmarshallerContext> {
    private static SslPolicyStaxUnmarshaller instance;

    @Override
    public SslPolicy unmarshall(StaxUnmarshallerContext context) throws Exception {
        SslPolicy sslPolicy = new SslPolicy();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return sslPolicy;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("SslProtocols", targetDepth)) {
                    sslPolicy.withSslProtocols(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("SslProtocols/member", targetDepth)) {
                    sslPolicy.withSslProtocols(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Ciphers", targetDepth)) {
                    sslPolicy.withCiphers(new ArrayList<Cipher>());
                    continue;
                }
                if (context.testExpression("Ciphers/member", targetDepth)) {
                    sslPolicy.withCiphers(CipherStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Name", targetDepth)) continue;
                sslPolicy.setName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return sslPolicy;
    }

    public static SslPolicyStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new SslPolicyStaxUnmarshaller();
        }
        return instance;
    }
}

