/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.simpleworkflow.model.RecordActivityTaskHeartbeatRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class RecordActivityTaskHeartbeatRequestMarshaller
implements Marshaller<Request<RecordActivityTaskHeartbeatRequest>, RecordActivityTaskHeartbeatRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public RecordActivityTaskHeartbeatRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<RecordActivityTaskHeartbeatRequest> marshall(RecordActivityTaskHeartbeatRequest recordActivityTaskHeartbeatRequest) {
        if (recordActivityTaskHeartbeatRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<RecordActivityTaskHeartbeatRequest> request = new DefaultRequest<RecordActivityTaskHeartbeatRequest>(recordActivityTaskHeartbeatRequest, "AmazonSimpleWorkflow");
        request.addHeader("X-Amz-Target", "SimpleWorkflowService.RecordActivityTaskHeartbeat");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (recordActivityTaskHeartbeatRequest.getTaskToken() != null) {
                jsonGenerator.writeFieldName("taskToken").writeValue(recordActivityTaskHeartbeatRequest.getTaskToken());
            }
            if (recordActivityTaskHeartbeatRequest.getDetails() != null) {
                jsonGenerator.writeFieldName("details").writeValue(recordActivityTaskHeartbeatRequest.getDetails());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

