/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticsearch.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.elasticsearch.model.DeleteElasticsearchDomainRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class DeleteElasticsearchDomainRequestMarshaller
implements Marshaller<Request<DeleteElasticsearchDomainRequest>, DeleteElasticsearchDomainRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DeleteElasticsearchDomainRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DeleteElasticsearchDomainRequest> marshall(DeleteElasticsearchDomainRequest deleteElasticsearchDomainRequest) {
        if (deleteElasticsearchDomainRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteElasticsearchDomainRequest> request = new DefaultRequest<DeleteElasticsearchDomainRequest>(deleteElasticsearchDomainRequest, "AWSElasticsearch");
        request.setHttpMethod(HttpMethodName.DELETE);
        String uriResourcePath = "/2015-01-01/es/domain/{DomainName}";
        uriResourcePath = uriResourcePath.replace("{DomainName}", deleteElasticsearchDomainRequest.getDomainName() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(deleteElasticsearchDomainRequest.getDomainName()), false) : "");
        request.setResourcePath(uriResourcePath);
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

