/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotdata.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.iotdata.model.PublishRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.BinaryUtils;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;

public class PublishRequestMarshaller
implements Marshaller<Request<PublishRequest>, PublishRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public PublishRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<PublishRequest> marshall(PublishRequest publishRequest) {
        if (publishRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PublishRequest> request = new DefaultRequest<PublishRequest>(publishRequest, "AWSIotData");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/topics/{topic}";
        uriResourcePath = uriResourcePath.replace("{topic}", publishRequest.getTopic() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(publishRequest.getTopic()), false) : "");
        request.setResourcePath(uriResourcePath);
        if (publishRequest.getQos() != null) {
            request.addParameter("qos", StringUtils.fromInteger(publishRequest.getQos()));
        }
        request.setContent(BinaryUtils.toStream(publishRequest.getPayload()));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

