/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.iot.model.TransferCertificateRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class TransferCertificateRequestMarshaller
implements Marshaller<Request<TransferCertificateRequest>, TransferCertificateRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "application/x-amz-json-1.1";
    private final SdkJsonProtocolFactory protocolFactory;

    public TransferCertificateRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<TransferCertificateRequest> marshall(TransferCertificateRequest transferCertificateRequest) {
        if (transferCertificateRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<TransferCertificateRequest> request = new DefaultRequest<TransferCertificateRequest>(transferCertificateRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.PATCH);
        String uriResourcePath = "/transfer-certificate/{certificateId}";
        uriResourcePath = uriResourcePath.replace("{certificateId}", transferCertificateRequest.getCertificateId() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(transferCertificateRequest.getCertificateId()), false) : "");
        request.setResourcePath(uriResourcePath);
        if (transferCertificateRequest.getTargetAwsAccount() != null) {
            request.addParameter("targetAwsAccount", StringUtils.fromString(transferCertificateRequest.getTargetAwsAccount()));
        }
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (transferCertificateRequest.getTransferMessage() != null) {
                jsonGenerator.writeFieldName("transferMessage").writeValue(transferCertificateRequest.getTransferMessage());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

