/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.inspector.model.StartAssessmentRunRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class StartAssessmentRunRequestMarshaller
implements Marshaller<Request<StartAssessmentRunRequest>, StartAssessmentRunRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public StartAssessmentRunRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<StartAssessmentRunRequest> marshall(StartAssessmentRunRequest startAssessmentRunRequest) {
        if (startAssessmentRunRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<StartAssessmentRunRequest> request = new DefaultRequest<StartAssessmentRunRequest>(startAssessmentRunRequest, "AmazonInspector");
        request.addHeader("X-Amz-Target", "InspectorService.StartAssessmentRun");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (startAssessmentRunRequest.getAssessmentTemplateArn() != null) {
                jsonGenerator.writeFieldName("assessmentTemplateArn").writeValue(startAssessmentRunRequest.getAssessmentTemplateArn());
            }
            if (startAssessmentRunRequest.getAssessmentRunName() != null) {
                jsonGenerator.writeFieldName("assessmentRunName").writeValue(startAssessmentRunRequest.getAssessmentRunName());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

