/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticsearch.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.elasticsearch.model.CreateElasticsearchDomainRequest;
import com.amazonaws.services.elasticsearch.model.transform.EBSOptionsJsonMarshaller;
import com.amazonaws.services.elasticsearch.model.transform.ElasticsearchClusterConfigJsonMarshaller;
import com.amazonaws.services.elasticsearch.model.transform.SnapshotOptionsJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.util.Map;

public class CreateElasticsearchDomainRequestMarshaller
implements Marshaller<Request<CreateElasticsearchDomainRequest>, CreateElasticsearchDomainRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "application/x-amz-json-1.1";
    private final SdkJsonProtocolFactory protocolFactory;

    public CreateElasticsearchDomainRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<CreateElasticsearchDomainRequest> marshall(CreateElasticsearchDomainRequest createElasticsearchDomainRequest) {
        if (createElasticsearchDomainRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateElasticsearchDomainRequest> request = new DefaultRequest<CreateElasticsearchDomainRequest>(createElasticsearchDomainRequest, "AWSElasticsearch");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/2015-01-01/es/domain";
        request.setResourcePath(uriResourcePath);
        try {
            Map<String, String> advancedOptionsMap;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createElasticsearchDomainRequest.getDomainName() != null) {
                jsonGenerator.writeFieldName("DomainName").writeValue(createElasticsearchDomainRequest.getDomainName());
            }
            if (createElasticsearchDomainRequest.getElasticsearchClusterConfig() != null) {
                jsonGenerator.writeFieldName("ElasticsearchClusterConfig");
                ElasticsearchClusterConfigJsonMarshaller.getInstance().marshall(createElasticsearchDomainRequest.getElasticsearchClusterConfig(), jsonGenerator);
            }
            if (createElasticsearchDomainRequest.getEBSOptions() != null) {
                jsonGenerator.writeFieldName("EBSOptions");
                EBSOptionsJsonMarshaller.getInstance().marshall(createElasticsearchDomainRequest.getEBSOptions(), jsonGenerator);
            }
            if (createElasticsearchDomainRequest.getAccessPolicies() != null) {
                jsonGenerator.writeFieldName("AccessPolicies").writeValue(createElasticsearchDomainRequest.getAccessPolicies());
            }
            if (createElasticsearchDomainRequest.getSnapshotOptions() != null) {
                jsonGenerator.writeFieldName("SnapshotOptions");
                SnapshotOptionsJsonMarshaller.getInstance().marshall(createElasticsearchDomainRequest.getSnapshotOptions(), jsonGenerator);
            }
            if ((advancedOptionsMap = createElasticsearchDomainRequest.getAdvancedOptions()) != null) {
                jsonGenerator.writeFieldName("AdvancedOptions");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, String> advancedOptionsMapValue : advancedOptionsMap.entrySet()) {
                    if (advancedOptionsMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(advancedOptionsMapValue.getKey());
                    jsonGenerator.writeValue(advancedOptionsMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

