/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecr.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.ecr.model.UploadLayerPartRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class UploadLayerPartRequestMarshaller
implements Marshaller<Request<UploadLayerPartRequest>, UploadLayerPartRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public UploadLayerPartRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<UploadLayerPartRequest> marshall(UploadLayerPartRequest uploadLayerPartRequest) {
        if (uploadLayerPartRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UploadLayerPartRequest> request = new DefaultRequest<UploadLayerPartRequest>(uploadLayerPartRequest, "AmazonECR");
        request.addHeader("X-Amz-Target", "AmazonEC2ContainerRegistry_V20150921.UploadLayerPart");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (uploadLayerPartRequest.getRegistryId() != null) {
                jsonGenerator.writeFieldName("registryId").writeValue(uploadLayerPartRequest.getRegistryId());
            }
            if (uploadLayerPartRequest.getRepositoryName() != null) {
                jsonGenerator.writeFieldName("repositoryName").writeValue(uploadLayerPartRequest.getRepositoryName());
            }
            if (uploadLayerPartRequest.getUploadId() != null) {
                jsonGenerator.writeFieldName("uploadId").writeValue(uploadLayerPartRequest.getUploadId());
            }
            if (uploadLayerPartRequest.getPartFirstByte() != null) {
                jsonGenerator.writeFieldName("partFirstByte").writeValue(uploadLayerPartRequest.getPartFirstByte());
            }
            if (uploadLayerPartRequest.getPartLastByte() != null) {
                jsonGenerator.writeFieldName("partLastByte").writeValue(uploadLayerPartRequest.getPartLastByte());
            }
            if (uploadLayerPartRequest.getLayerPartBlob() != null) {
                jsonGenerator.writeFieldName("layerPartBlob").writeValue(uploadLayerPartRequest.getLayerPartBlob());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

