/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.config.model.GetComplianceDetailsByConfigRuleRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class GetComplianceDetailsByConfigRuleRequestMarshaller
implements Marshaller<Request<GetComplianceDetailsByConfigRuleRequest>, GetComplianceDetailsByConfigRuleRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public GetComplianceDetailsByConfigRuleRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<GetComplianceDetailsByConfigRuleRequest> marshall(GetComplianceDetailsByConfigRuleRequest getComplianceDetailsByConfigRuleRequest) {
        if (getComplianceDetailsByConfigRuleRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetComplianceDetailsByConfigRuleRequest> request = new DefaultRequest<GetComplianceDetailsByConfigRuleRequest>(getComplianceDetailsByConfigRuleRequest, "AmazonConfig");
        request.addHeader("X-Amz-Target", "StarlingDoveService.GetComplianceDetailsByConfigRule");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList complianceTypesList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (getComplianceDetailsByConfigRuleRequest.getConfigRuleName() != null) {
                jsonGenerator.writeFieldName("ConfigRuleName").writeValue(getComplianceDetailsByConfigRuleRequest.getConfigRuleName());
            }
            if (!(complianceTypesList = (SdkInternalList)getComplianceDetailsByConfigRuleRequest.getComplianceTypes()).isEmpty() || !complianceTypesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("ComplianceTypes");
                jsonGenerator.writeStartArray();
                for (String complianceTypesListValue : complianceTypesList) {
                    if (complianceTypesListValue == null) continue;
                    jsonGenerator.writeValue(complianceTypesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (getComplianceDetailsByConfigRuleRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("Limit").writeValue(getComplianceDetailsByConfigRuleRequest.getLimit());
            }
            if (getComplianceDetailsByConfigRuleRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(getComplianceDetailsByConfigRuleRequest.getNextToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

