/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.apigateway.model.GetBasePathMappingsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class GetBasePathMappingsRequestMarshaller
implements Marshaller<Request<GetBasePathMappingsRequest>, GetBasePathMappingsRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "application/x-amz-json-1.1";
    private final SdkJsonProtocolFactory protocolFactory;

    public GetBasePathMappingsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<GetBasePathMappingsRequest> marshall(GetBasePathMappingsRequest getBasePathMappingsRequest) {
        if (getBasePathMappingsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetBasePathMappingsRequest> request = new DefaultRequest<GetBasePathMappingsRequest>(getBasePathMappingsRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/domainnames/{domain_name}/basepathmappings";
        uriResourcePath = uriResourcePath.replace("{domain_name}", getBasePathMappingsRequest.getDomainName() != null ? SdkHttpUtils.urlEncode(StringUtils.fromString(getBasePathMappingsRequest.getDomainName()), false) : "");
        request.setResourcePath(uriResourcePath);
        if (getBasePathMappingsRequest.getPosition() != null) {
            request.addParameter("position", StringUtils.fromString(getBasePathMappingsRequest.getPosition()));
        }
        if (getBasePathMappingsRequest.getLimit() != null) {
            request.addParameter("limit", StringUtils.fromInteger(getBasePathMappingsRequest.getLimit()));
        }
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

