/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.NatGatewayAddress;
import com.amazonaws.services.ec2.model.NatGatewayState;
import com.amazonaws.services.ec2.model.ProvisionedBandwidth;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class NatGateway
implements Serializable,
Cloneable {
    private String vpcId;
    private String subnetId;
    private String natGatewayId;
    private Date createTime;
    private Date deleteTime;
    private SdkInternalList<NatGatewayAddress> natGatewayAddresses;
    private String state;
    private String failureCode;
    private String failureMessage;
    private ProvisionedBandwidth provisionedBandwidth;

    public void setVpcId(String vpcId) {
        this.vpcId = vpcId;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public NatGateway withVpcId(String vpcId) {
        this.setVpcId(vpcId);
        return this;
    }

    public void setSubnetId(String subnetId) {
        this.subnetId = subnetId;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public NatGateway withSubnetId(String subnetId) {
        this.setSubnetId(subnetId);
        return this;
    }

    public void setNatGatewayId(String natGatewayId) {
        this.natGatewayId = natGatewayId;
    }

    public String getNatGatewayId() {
        return this.natGatewayId;
    }

    public NatGateway withNatGatewayId(String natGatewayId) {
        this.setNatGatewayId(natGatewayId);
        return this;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public NatGateway withCreateTime(Date createTime) {
        this.setCreateTime(createTime);
        return this;
    }

    public void setDeleteTime(Date deleteTime) {
        this.deleteTime = deleteTime;
    }

    public Date getDeleteTime() {
        return this.deleteTime;
    }

    public NatGateway withDeleteTime(Date deleteTime) {
        this.setDeleteTime(deleteTime);
        return this;
    }

    public List<NatGatewayAddress> getNatGatewayAddresses() {
        if (this.natGatewayAddresses == null) {
            this.natGatewayAddresses = new SdkInternalList();
        }
        return this.natGatewayAddresses;
    }

    public void setNatGatewayAddresses(Collection<NatGatewayAddress> natGatewayAddresses) {
        if (natGatewayAddresses == null) {
            this.natGatewayAddresses = null;
            return;
        }
        this.natGatewayAddresses = new SdkInternalList<NatGatewayAddress>(natGatewayAddresses);
    }

    public NatGateway withNatGatewayAddresses(NatGatewayAddress ... natGatewayAddresses) {
        if (this.natGatewayAddresses == null) {
            this.setNatGatewayAddresses(new SdkInternalList<NatGatewayAddress>(natGatewayAddresses.length));
        }
        for (NatGatewayAddress ele : natGatewayAddresses) {
            this.natGatewayAddresses.add(ele);
        }
        return this;
    }

    public NatGateway withNatGatewayAddresses(Collection<NatGatewayAddress> natGatewayAddresses) {
        this.setNatGatewayAddresses(natGatewayAddresses);
        return this;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getState() {
        return this.state;
    }

    public NatGateway withState(String state) {
        this.setState(state);
        return this;
    }

    @JsonIgnore
    public void setState(NatGatewayState state) {
        this.state = state.toString();
    }

    public NatGateway withState(NatGatewayState state) {
        this.setState(state);
        return this;
    }

    public void setFailureCode(String failureCode) {
        this.failureCode = failureCode;
    }

    public String getFailureCode() {
        return this.failureCode;
    }

    public NatGateway withFailureCode(String failureCode) {
        this.setFailureCode(failureCode);
        return this;
    }

    public void setFailureMessage(String failureMessage) {
        this.failureMessage = failureMessage;
    }

    public String getFailureMessage() {
        return this.failureMessage;
    }

    public NatGateway withFailureMessage(String failureMessage) {
        this.setFailureMessage(failureMessage);
        return this;
    }

    public void setProvisionedBandwidth(ProvisionedBandwidth provisionedBandwidth) {
        this.provisionedBandwidth = provisionedBandwidth;
    }

    public ProvisionedBandwidth getProvisionedBandwidth() {
        return this.provisionedBandwidth;
    }

    public NatGateway withProvisionedBandwidth(ProvisionedBandwidth provisionedBandwidth) {
        this.setProvisionedBandwidth(provisionedBandwidth);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getVpcId() != null) {
            sb.append("VpcId: ").append(this.getVpcId()).append(",");
        }
        if (this.getSubnetId() != null) {
            sb.append("SubnetId: ").append(this.getSubnetId()).append(",");
        }
        if (this.getNatGatewayId() != null) {
            sb.append("NatGatewayId: ").append(this.getNatGatewayId()).append(",");
        }
        if (this.getCreateTime() != null) {
            sb.append("CreateTime: ").append(this.getCreateTime()).append(",");
        }
        if (this.getDeleteTime() != null) {
            sb.append("DeleteTime: ").append(this.getDeleteTime()).append(",");
        }
        if (this.getNatGatewayAddresses() != null) {
            sb.append("NatGatewayAddresses: ").append(this.getNatGatewayAddresses()).append(",");
        }
        if (this.getState() != null) {
            sb.append("State: ").append(this.getState()).append(",");
        }
        if (this.getFailureCode() != null) {
            sb.append("FailureCode: ").append(this.getFailureCode()).append(",");
        }
        if (this.getFailureMessage() != null) {
            sb.append("FailureMessage: ").append(this.getFailureMessage()).append(",");
        }
        if (this.getProvisionedBandwidth() != null) {
            sb.append("ProvisionedBandwidth: ").append(this.getProvisionedBandwidth());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NatGateway)) {
            return false;
        }
        NatGateway other = (NatGateway)obj;
        if (other.getVpcId() == null ^ this.getVpcId() == null) {
            return false;
        }
        if (other.getVpcId() != null && !other.getVpcId().equals(this.getVpcId())) {
            return false;
        }
        if (other.getSubnetId() == null ^ this.getSubnetId() == null) {
            return false;
        }
        if (other.getSubnetId() != null && !other.getSubnetId().equals(this.getSubnetId())) {
            return false;
        }
        if (other.getNatGatewayId() == null ^ this.getNatGatewayId() == null) {
            return false;
        }
        if (other.getNatGatewayId() != null && !other.getNatGatewayId().equals(this.getNatGatewayId())) {
            return false;
        }
        if (other.getCreateTime() == null ^ this.getCreateTime() == null) {
            return false;
        }
        if (other.getCreateTime() != null && !other.getCreateTime().equals(this.getCreateTime())) {
            return false;
        }
        if (other.getDeleteTime() == null ^ this.getDeleteTime() == null) {
            return false;
        }
        if (other.getDeleteTime() != null && !other.getDeleteTime().equals(this.getDeleteTime())) {
            return false;
        }
        if (other.getNatGatewayAddresses() == null ^ this.getNatGatewayAddresses() == null) {
            return false;
        }
        if (other.getNatGatewayAddresses() != null && !other.getNatGatewayAddresses().equals(this.getNatGatewayAddresses())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getFailureCode() == null ^ this.getFailureCode() == null) {
            return false;
        }
        if (other.getFailureCode() != null && !other.getFailureCode().equals(this.getFailureCode())) {
            return false;
        }
        if (other.getFailureMessage() == null ^ this.getFailureMessage() == null) {
            return false;
        }
        if (other.getFailureMessage() != null && !other.getFailureMessage().equals(this.getFailureMessage())) {
            return false;
        }
        if (other.getProvisionedBandwidth() == null ^ this.getProvisionedBandwidth() == null) {
            return false;
        }
        return other.getProvisionedBandwidth() == null || other.getProvisionedBandwidth().equals(this.getProvisionedBandwidth());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getVpcId() == null ? 0 : this.getVpcId().hashCode());
        hashCode = 31 * hashCode + (this.getSubnetId() == null ? 0 : this.getSubnetId().hashCode());
        hashCode = 31 * hashCode + (this.getNatGatewayId() == null ? 0 : this.getNatGatewayId().hashCode());
        hashCode = 31 * hashCode + (this.getCreateTime() == null ? 0 : this.getCreateTime().hashCode());
        hashCode = 31 * hashCode + (this.getDeleteTime() == null ? 0 : this.getDeleteTime().hashCode());
        hashCode = 31 * hashCode + (this.getNatGatewayAddresses() == null ? 0 : this.getNatGatewayAddresses().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getFailureCode() == null ? 0 : this.getFailureCode().hashCode());
        hashCode = 31 * hashCode + (this.getFailureMessage() == null ? 0 : this.getFailureMessage().hashCode());
        hashCode = 31 * hashCode + (this.getProvisionedBandwidth() == null ? 0 : this.getProvisionedBandwidth().hashCode());
        return hashCode;
    }

    public NatGateway clone() {
        try {
            return (NatGateway)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

