/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.waiters;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.redshift.AmazonRedshift;
import com.amazonaws.services.redshift.model.DescribeClusterSnapshotsRequest;
import com.amazonaws.services.redshift.model.DescribeClusterSnapshotsResult;
import com.amazonaws.services.redshift.model.DescribeClustersRequest;
import com.amazonaws.services.redshift.model.DescribeClustersResult;
import com.amazonaws.services.redshift.waiters.ClusterAvailable;
import com.amazonaws.services.redshift.waiters.ClusterDeleted;
import com.amazonaws.services.redshift.waiters.ClusterRestored;
import com.amazonaws.services.redshift.waiters.DescribeClusterSnapshotsFunction;
import com.amazonaws.services.redshift.waiters.DescribeClustersFunction;
import com.amazonaws.services.redshift.waiters.SnapshotAvailable;
import com.amazonaws.waiters.FixedDelayStrategy;
import com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import com.amazonaws.waiters.PollingStrategy;
import com.amazonaws.waiters.Waiter;
import com.amazonaws.waiters.WaiterBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class AmazonRedshiftWaiters {
    private final AmazonRedshift client;
    private final ExecutorService executorService = Executors.newFixedThreadPool(50);

    @SdkInternalApi
    public AmazonRedshiftWaiters(AmazonRedshift client) {
        this.client = client;
    }

    public Waiter<DescribeClustersRequest> clusterDeleted() {
        return new WaiterBuilder<DescribeClustersRequest, DescribeClustersResult>().withSdkFunction(new DescribeClustersFunction(this.client)).withAcceptors(new ClusterDeleted.IsClusterNotFoundMatcher(), new ClusterDeleted.IsCreatingMatcher(), new ClusterDeleted.IsModifyingMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(30), new FixedDelayStrategy(60))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeClusterSnapshotsRequest> snapshotAvailable() {
        return new WaiterBuilder<DescribeClusterSnapshotsRequest, DescribeClusterSnapshotsResult>().withSdkFunction(new DescribeClusterSnapshotsFunction(this.client)).withAcceptors(new SnapshotAvailable.IsAvailableMatcher(), new SnapshotAvailable.IsFailedMatcher(), new SnapshotAvailable.IsDeletedMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(20), new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeClustersRequest> clusterRestored() {
        return new WaiterBuilder<DescribeClustersRequest, DescribeClustersResult>().withSdkFunction(new DescribeClustersFunction(this.client)).withAcceptors(new ClusterRestored.IsCompletedMatcher(), new ClusterRestored.IsDeletingMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(30), new FixedDelayStrategy(60))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeClustersRequest> clusterAvailable() {
        return new WaiterBuilder<DescribeClustersRequest, DescribeClustersResult>().withSdkFunction(new DescribeClustersFunction(this.client)).withAcceptors(new ClusterAvailable.IsAvailableMatcher(), new ClusterAvailable.IsDeletingMatcher(), new ClusterAvailable.IsClusterNotFoundMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(30), new FixedDelayStrategy(60))).withExecutorService(this.executorService).build();
    }
}

