/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.health;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.health.AWSHealthAsync;
import com.amazonaws.services.health.AWSHealthAsyncClientBuilder;
import com.amazonaws.services.health.AWSHealthClient;
import com.amazonaws.services.health.model.DescribeAffectedEntitiesRequest;
import com.amazonaws.services.health.model.DescribeAffectedEntitiesResult;
import com.amazonaws.services.health.model.DescribeEntityAggregatesRequest;
import com.amazonaws.services.health.model.DescribeEntityAggregatesResult;
import com.amazonaws.services.health.model.DescribeEventAggregatesRequest;
import com.amazonaws.services.health.model.DescribeEventAggregatesResult;
import com.amazonaws.services.health.model.DescribeEventDetailsRequest;
import com.amazonaws.services.health.model.DescribeEventDetailsResult;
import com.amazonaws.services.health.model.DescribeEventTypesRequest;
import com.amazonaws.services.health.model.DescribeEventTypesResult;
import com.amazonaws.services.health.model.DescribeEventsRequest;
import com.amazonaws.services.health.model.DescribeEventsResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSHealthAsyncClient
extends AWSHealthClient
implements AWSHealthAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    @Deprecated
    public AWSHealthAsyncClient() {
        this(DefaultAWSCredentialsProviderChain.getInstance());
    }

    @Deprecated
    public AWSHealthAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AWSHealthAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AWSHealthAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AWSHealthAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    @Deprecated
    public AWSHealthAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AWSHealthAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AWSHealthAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AWSHealthAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public static AWSHealthAsyncClientBuilder asyncBuilder() {
        return AWSHealthAsyncClientBuilder.standard();
    }

    AWSHealthAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<DescribeAffectedEntitiesResult> describeAffectedEntitiesAsync(DescribeAffectedEntitiesRequest request) {
        return this.describeAffectedEntitiesAsync(request, null);
    }

    @Override
    public Future<DescribeAffectedEntitiesResult> describeAffectedEntitiesAsync(final DescribeAffectedEntitiesRequest request, final AsyncHandler<DescribeAffectedEntitiesRequest, DescribeAffectedEntitiesResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeAffectedEntitiesResult>(){

            @Override
            public DescribeAffectedEntitiesResult call() throws Exception {
                DescribeAffectedEntitiesResult result;
                try {
                    result = AWSHealthAsyncClient.this.describeAffectedEntities(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeEntityAggregatesResult> describeEntityAggregatesAsync(DescribeEntityAggregatesRequest request) {
        return this.describeEntityAggregatesAsync(request, null);
    }

    @Override
    public Future<DescribeEntityAggregatesResult> describeEntityAggregatesAsync(final DescribeEntityAggregatesRequest request, final AsyncHandler<DescribeEntityAggregatesRequest, DescribeEntityAggregatesResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeEntityAggregatesResult>(){

            @Override
            public DescribeEntityAggregatesResult call() throws Exception {
                DescribeEntityAggregatesResult result;
                try {
                    result = AWSHealthAsyncClient.this.describeEntityAggregates(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeEventAggregatesResult> describeEventAggregatesAsync(DescribeEventAggregatesRequest request) {
        return this.describeEventAggregatesAsync(request, null);
    }

    @Override
    public Future<DescribeEventAggregatesResult> describeEventAggregatesAsync(final DescribeEventAggregatesRequest request, final AsyncHandler<DescribeEventAggregatesRequest, DescribeEventAggregatesResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeEventAggregatesResult>(){

            @Override
            public DescribeEventAggregatesResult call() throws Exception {
                DescribeEventAggregatesResult result;
                try {
                    result = AWSHealthAsyncClient.this.describeEventAggregates(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeEventDetailsResult> describeEventDetailsAsync(DescribeEventDetailsRequest request) {
        return this.describeEventDetailsAsync(request, null);
    }

    @Override
    public Future<DescribeEventDetailsResult> describeEventDetailsAsync(final DescribeEventDetailsRequest request, final AsyncHandler<DescribeEventDetailsRequest, DescribeEventDetailsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeEventDetailsResult>(){

            @Override
            public DescribeEventDetailsResult call() throws Exception {
                DescribeEventDetailsResult result;
                try {
                    result = AWSHealthAsyncClient.this.describeEventDetails(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeEventTypesResult> describeEventTypesAsync(DescribeEventTypesRequest request) {
        return this.describeEventTypesAsync(request, null);
    }

    @Override
    public Future<DescribeEventTypesResult> describeEventTypesAsync(final DescribeEventTypesRequest request, final AsyncHandler<DescribeEventTypesRequest, DescribeEventTypesResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeEventTypesResult>(){

            @Override
            public DescribeEventTypesResult call() throws Exception {
                DescribeEventTypesResult result;
                try {
                    result = AWSHealthAsyncClient.this.describeEventTypes(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeEventsResult> describeEventsAsync(DescribeEventsRequest request) {
        return this.describeEventsAsync(request, null);
    }

    @Override
    public Future<DescribeEventsResult> describeEventsAsync(final DescribeEventsRequest request, final AsyncHandler<DescribeEventsRequest, DescribeEventsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeEventsResult>(){

            @Override
            public DescribeEventsResult call() throws Exception {
                DescribeEventsResult result;
                try {
                    result = AWSHealthAsyncClient.this.describeEvents(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

