/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancing.waiters;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.elasticloadbalancing.AmazonElasticLoadBalancing;
import com.amazonaws.services.elasticloadbalancing.model.DescribeInstanceHealthRequest;
import com.amazonaws.services.elasticloadbalancing.model.DescribeInstanceHealthResult;
import com.amazonaws.services.elasticloadbalancing.waiters.AnyInstanceInService;
import com.amazonaws.services.elasticloadbalancing.waiters.DescribeInstanceHealthFunction;
import com.amazonaws.services.elasticloadbalancing.waiters.InstanceDeregistered;
import com.amazonaws.services.elasticloadbalancing.waiters.InstanceInService;
import com.amazonaws.waiters.FixedDelayStrategy;
import com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import com.amazonaws.waiters.PollingStrategy;
import com.amazonaws.waiters.Waiter;
import com.amazonaws.waiters.WaiterBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class AmazonElasticLoadBalancingWaiters {
    private final AmazonElasticLoadBalancing client;
    private final ExecutorService executorService = Executors.newFixedThreadPool(50);

    @SdkInternalApi
    public AmazonElasticLoadBalancingWaiters(AmazonElasticLoadBalancing client) {
        this.client = client;
    }

    public Waiter<DescribeInstanceHealthRequest> anyInstanceInService() {
        return new WaiterBuilder<DescribeInstanceHealthRequest, DescribeInstanceHealthResult>().withSdkFunction(new DescribeInstanceHealthFunction(this.client)).withAcceptors(new AnyInstanceInService.IsInServiceMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(40), new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeInstanceHealthRequest> instanceDeregistered() {
        return new WaiterBuilder<DescribeInstanceHealthRequest, DescribeInstanceHealthResult>().withSdkFunction(new DescribeInstanceHealthFunction(this.client)).withAcceptors(new InstanceDeregistered.IsOutOfServiceMatcher(), new InstanceDeregistered.IsInvalidInstanceMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(40), new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeInstanceHealthRequest> instanceInService() {
        return new WaiterBuilder<DescribeInstanceHealthRequest, DescribeInstanceHealthResult>().withSdkFunction(new DescribeInstanceHealthFunction(this.client)).withAcceptors(new InstanceInService.IsInServiceMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(40), new FixedDelayStrategy(15))).withExecutorService(this.executorService).build();
    }
}

