/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codedeploy.model.LifecycleErrorCode;
import com.amazonaws.services.codedeploy.model.transform.DiagnosticsMarshaller;
import java.io.Serializable;

public class Diagnostics
implements Serializable,
Cloneable,
StructuredPojo {
    private String errorCode;
    private String scriptName;
    private String message;
    private String logTail;

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public Diagnostics withErrorCode(String errorCode) {
        this.setErrorCode(errorCode);
        return this;
    }

    public void setErrorCode(LifecycleErrorCode errorCode) {
        this.errorCode = errorCode.toString();
    }

    public Diagnostics withErrorCode(LifecycleErrorCode errorCode) {
        this.setErrorCode(errorCode);
        return this;
    }

    public void setScriptName(String scriptName) {
        this.scriptName = scriptName;
    }

    public String getScriptName() {
        return this.scriptName;
    }

    public Diagnostics withScriptName(String scriptName) {
        this.setScriptName(scriptName);
        return this;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public Diagnostics withMessage(String message) {
        this.setMessage(message);
        return this;
    }

    public void setLogTail(String logTail) {
        this.logTail = logTail;
    }

    public String getLogTail() {
        return this.logTail;
    }

    public Diagnostics withLogTail(String logTail) {
        this.setLogTail(logTail);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getErrorCode() != null) {
            sb.append("ErrorCode: ").append(this.getErrorCode()).append(",");
        }
        if (this.getScriptName() != null) {
            sb.append("ScriptName: ").append(this.getScriptName()).append(",");
        }
        if (this.getMessage() != null) {
            sb.append("Message: ").append(this.getMessage()).append(",");
        }
        if (this.getLogTail() != null) {
            sb.append("LogTail: ").append(this.getLogTail());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Diagnostics)) {
            return false;
        }
        Diagnostics other = (Diagnostics)obj;
        if (other.getErrorCode() == null ^ this.getErrorCode() == null) {
            return false;
        }
        if (other.getErrorCode() != null && !other.getErrorCode().equals(this.getErrorCode())) {
            return false;
        }
        if (other.getScriptName() == null ^ this.getScriptName() == null) {
            return false;
        }
        if (other.getScriptName() != null && !other.getScriptName().equals(this.getScriptName())) {
            return false;
        }
        if (other.getMessage() == null ^ this.getMessage() == null) {
            return false;
        }
        if (other.getMessage() != null && !other.getMessage().equals(this.getMessage())) {
            return false;
        }
        if (other.getLogTail() == null ^ this.getLogTail() == null) {
            return false;
        }
        return other.getLogTail() == null || other.getLogTail().equals(this.getLogTail());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getErrorCode() == null ? 0 : this.getErrorCode().hashCode());
        hashCode = 31 * hashCode + (this.getScriptName() == null ? 0 : this.getScriptName().hashCode());
        hashCode = 31 * hashCode + (this.getMessage() == null ? 0 : this.getMessage().hashCode());
        hashCode = 31 * hashCode + (this.getLogTail() == null ? 0 : this.getLogTail().hashCode());
        return hashCode;
    }

    public Diagnostics clone() {
        try {
            return (Diagnostics)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DiagnosticsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

