/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.storagegateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.storagegateway.model.DescribeCachediSCSIVolumesRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class DescribeCachediSCSIVolumesRequestMarshaller
implements Marshaller<Request<DescribeCachediSCSIVolumesRequest>, DescribeCachediSCSIVolumesRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DescribeCachediSCSIVolumesRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DescribeCachediSCSIVolumesRequest> marshall(DescribeCachediSCSIVolumesRequest describeCachediSCSIVolumesRequest) {
        if (describeCachediSCSIVolumesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeCachediSCSIVolumesRequest> request = new DefaultRequest<DescribeCachediSCSIVolumesRequest>(describeCachediSCSIVolumesRequest, "AWSStorageGateway");
        request.addHeader("X-Amz-Target", "StorageGateway_20130630.DescribeCachediSCSIVolumes");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            SdkInternalList volumeARNsList = (SdkInternalList)describeCachediSCSIVolumesRequest.getVolumeARNs();
            if (!volumeARNsList.isEmpty() || !volumeARNsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("VolumeARNs");
                jsonGenerator.writeStartArray();
                for (String volumeARNsListValue : volumeARNsList) {
                    if (volumeARNsListValue == null) continue;
                    jsonGenerator.writeValue(volumeARNsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

