/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.kinesis.model.DescribeStreamRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class DescribeStreamRequestMarshaller
implements Marshaller<Request<DescribeStreamRequest>, DescribeStreamRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DescribeStreamRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DescribeStreamRequest> marshall(DescribeStreamRequest describeStreamRequest) {
        if (describeStreamRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeStreamRequest> request = new DefaultRequest<DescribeStreamRequest>(describeStreamRequest, "AmazonKinesis");
        request.addHeader("X-Amz-Target", "Kinesis_20131202.DescribeStream");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (describeStreamRequest.getStreamName() != null) {
                jsonGenerator.writeFieldName("StreamName").writeValue(describeStreamRequest.getStreamName());
            }
            if (describeStreamRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("Limit").writeValue(describeStreamRequest.getLimit());
            }
            if (describeStreamRequest.getExclusiveStartShardId() != null) {
                jsonGenerator.writeFieldName("ExclusiveStartShardId").writeValue(describeStreamRequest.getExclusiveStartShardId());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

