/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directconnect.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.directconnect.model.DescribeInterconnectLoaRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class DescribeInterconnectLoaRequestMarshaller
implements Marshaller<Request<DescribeInterconnectLoaRequest>, DescribeInterconnectLoaRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DescribeInterconnectLoaRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DescribeInterconnectLoaRequest> marshall(DescribeInterconnectLoaRequest describeInterconnectLoaRequest) {
        if (describeInterconnectLoaRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeInterconnectLoaRequest> request = new DefaultRequest<DescribeInterconnectLoaRequest>(describeInterconnectLoaRequest, "AmazonDirectConnect");
        request.addHeader("X-Amz-Target", "OvertureService.DescribeInterconnectLoa");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (describeInterconnectLoaRequest.getInterconnectId() != null) {
                jsonGenerator.writeFieldName("interconnectId").writeValue(describeInterconnectLoaRequest.getInterconnectId());
            }
            if (describeInterconnectLoaRequest.getProviderName() != null) {
                jsonGenerator.writeFieldName("providerName").writeValue(describeInterconnectLoaRequest.getProviderName());
            }
            if (describeInterconnectLoaRequest.getLoaContentType() != null) {
                jsonGenerator.writeFieldName("loaContentType").writeValue(describeInterconnectLoaRequest.getLoaContentType());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

