/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.config.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.config.model.ListDiscoveredResourcesRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class ListDiscoveredResourcesRequestMarshaller
implements Marshaller<Request<ListDiscoveredResourcesRequest>, ListDiscoveredResourcesRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public ListDiscoveredResourcesRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ListDiscoveredResourcesRequest> marshall(ListDiscoveredResourcesRequest listDiscoveredResourcesRequest) {
        if (listDiscoveredResourcesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListDiscoveredResourcesRequest> request = new DefaultRequest<ListDiscoveredResourcesRequest>(listDiscoveredResourcesRequest, "AmazonConfig");
        request.addHeader("X-Amz-Target", "StarlingDoveService.ListDiscoveredResources");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList resourceIdsList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (listDiscoveredResourcesRequest.getResourceType() != null) {
                jsonGenerator.writeFieldName("resourceType").writeValue(listDiscoveredResourcesRequest.getResourceType());
            }
            if (!(resourceIdsList = (SdkInternalList)listDiscoveredResourcesRequest.getResourceIds()).isEmpty() || !resourceIdsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("resourceIds");
                jsonGenerator.writeStartArray();
                for (String resourceIdsListValue : resourceIdsList) {
                    if (resourceIdsListValue == null) continue;
                    jsonGenerator.writeValue(resourceIdsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (listDiscoveredResourcesRequest.getResourceName() != null) {
                jsonGenerator.writeFieldName("resourceName").writeValue(listDiscoveredResourcesRequest.getResourceName());
            }
            if (listDiscoveredResourcesRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("limit").writeValue(listDiscoveredResourcesRequest.getLimit());
            }
            if (listDiscoveredResourcesRequest.getIncludeDeletedResources() != null) {
                jsonGenerator.writeFieldName("includeDeletedResources").writeValue(listDiscoveredResourcesRequest.getIncludeDeletedResources());
            }
            if (listDiscoveredResourcesRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("nextToken").writeValue(listDiscoveredResourcesRequest.getNextToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

