/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.simplesystemsmanagement.model.DocumentFilter;
import com.amazonaws.services.simplesystemsmanagement.model.ListDocumentsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class ListDocumentsRequestMarshaller
implements Marshaller<Request<ListDocumentsRequest>, ListDocumentsRequest> {
    @Override
    public Request<ListDocumentsRequest> marshall(ListDocumentsRequest listDocumentsRequest) {
        if (listDocumentsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListDocumentsRequest> request = new DefaultRequest<ListDocumentsRequest>(listDocumentsRequest, "AWSSimpleSystemsManagement");
        String target = "AmazonSSM.ListDocuments";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            ListWithAutoConstructFlag documentFilterListList = (ListWithAutoConstructFlag)listDocumentsRequest.getDocumentFilterList();
            if (!(documentFilterListList == null || documentFilterListList.isAutoConstruct() && documentFilterListList.isEmpty())) {
                jsonWriter.key("DocumentFilterList");
                jsonWriter.array();
                for (DocumentFilter documentFilterListListValue : documentFilterListList) {
                    if (documentFilterListListValue == null) continue;
                    jsonWriter.object();
                    if (documentFilterListListValue.getKey() != null) {
                        jsonWriter.key("key").value(documentFilterListListValue.getKey());
                    }
                    if (documentFilterListListValue.getValue() != null) {
                        jsonWriter.key("value").value(documentFilterListListValue.getValue());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            if (listDocumentsRequest.getMaxResults() != null) {
                jsonWriter.key("MaxResults").value(listDocumentsRequest.getMaxResults());
            }
            if (listDocumentsRequest.getNextToken() != null) {
                jsonWriter.key("NextToken").value(listDocumentsRequest.getNextToken());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

