/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.devicefarm.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.devicefarm.model.Suite;
import com.amazonaws.services.devicefarm.model.transform.CountersJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class SuiteJsonMarshaller {
    private static SuiteJsonMarshaller instance;

    public void marshall(Suite suite, JSONWriter jsonWriter) {
        if (suite == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (suite.getArn() != null) {
                jsonWriter.key("arn").value(suite.getArn());
            }
            if (suite.getName() != null) {
                jsonWriter.key("name").value(suite.getName());
            }
            if (suite.getType() != null) {
                jsonWriter.key("type").value(suite.getType());
            }
            if (suite.getCreated() != null) {
                jsonWriter.key("created").value(suite.getCreated());
            }
            if (suite.getStatus() != null) {
                jsonWriter.key("status").value(suite.getStatus());
            }
            if (suite.getResult() != null) {
                jsonWriter.key("result").value(suite.getResult());
            }
            if (suite.getStarted() != null) {
                jsonWriter.key("started").value(suite.getStarted());
            }
            if (suite.getStopped() != null) {
                jsonWriter.key("stopped").value(suite.getStopped());
            }
            if (suite.getCounters() != null) {
                jsonWriter.key("counters");
                CountersJsonMarshaller.getInstance().marshall(suite.getCounters(), jsonWriter);
            }
            if (suite.getMessage() != null) {
                jsonWriter.key("message").value(suite.getMessage());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static SuiteJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new SuiteJsonMarshaller();
        }
        return instance;
    }
}

