/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.gamelift.model.ResolveAliasRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;

public class ResolveAliasRequestMarshaller
implements Marshaller<Request<ResolveAliasRequest>, ResolveAliasRequest> {
    @Override
    public Request<ResolveAliasRequest> marshall(ResolveAliasRequest resolveAliasRequest) {
        if (resolveAliasRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ResolveAliasRequest> request = new DefaultRequest<ResolveAliasRequest>(resolveAliasRequest, "AmazonGameLift");
        request.addHeader("X-Amz-Target", "GameLift.ResolveAlias");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter(false, "1.1");
            jsonGenerator.writeStartObject();
            if (resolveAliasRequest.getAliasId() != null) {
                jsonGenerator.writeFieldName("AliasId").writeValue(resolveAliasRequest.getAliasId());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

