/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53domains.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.route53domains.model.RegisterDomainRequest;
import com.amazonaws.services.route53domains.model.transform.ContactDetailJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;

public class RegisterDomainRequestMarshaller
implements Marshaller<Request<RegisterDomainRequest>, RegisterDomainRequest> {
    @Override
    public Request<RegisterDomainRequest> marshall(RegisterDomainRequest registerDomainRequest) {
        if (registerDomainRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<RegisterDomainRequest> request = new DefaultRequest<RegisterDomainRequest>(registerDomainRequest, "AmazonRoute53Domains");
        request.addHeader("X-Amz-Target", "Route53Domains_v20140515.RegisterDomain");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter(false, "1.1");
            jsonGenerator.writeStartObject();
            if (registerDomainRequest.getDomainName() != null) {
                jsonGenerator.writeFieldName("DomainName").writeValue(registerDomainRequest.getDomainName());
            }
            if (registerDomainRequest.getIdnLangCode() != null) {
                jsonGenerator.writeFieldName("IdnLangCode").writeValue(registerDomainRequest.getIdnLangCode());
            }
            if (registerDomainRequest.getDurationInYears() != null) {
                jsonGenerator.writeFieldName("DurationInYears").writeValue(registerDomainRequest.getDurationInYears());
            }
            if (registerDomainRequest.getAutoRenew() != null) {
                jsonGenerator.writeFieldName("AutoRenew").writeValue(registerDomainRequest.getAutoRenew());
            }
            if (registerDomainRequest.getAdminContact() != null) {
                jsonGenerator.writeFieldName("AdminContact");
                ContactDetailJsonMarshaller.getInstance().marshall(registerDomainRequest.getAdminContact(), jsonGenerator);
            }
            if (registerDomainRequest.getRegistrantContact() != null) {
                jsonGenerator.writeFieldName("RegistrantContact");
                ContactDetailJsonMarshaller.getInstance().marshall(registerDomainRequest.getRegistrantContact(), jsonGenerator);
            }
            if (registerDomainRequest.getTechContact() != null) {
                jsonGenerator.writeFieldName("TechContact");
                ContactDetailJsonMarshaller.getInstance().marshall(registerDomainRequest.getTechContact(), jsonGenerator);
            }
            if (registerDomainRequest.getPrivacyProtectAdminContact() != null) {
                jsonGenerator.writeFieldName("PrivacyProtectAdminContact").writeValue(registerDomainRequest.getPrivacyProtectAdminContact());
            }
            if (registerDomainRequest.getPrivacyProtectRegistrantContact() != null) {
                jsonGenerator.writeFieldName("PrivacyProtectRegistrantContact").writeValue(registerDomainRequest.getPrivacyProtectRegistrantContact());
            }
            if (registerDomainRequest.getPrivacyProtectTechContact() != null) {
                jsonGenerator.writeFieldName("PrivacyProtectTechContact").writeValue(registerDomainRequest.getPrivacyProtectTechContact());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

