/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elasticmapreduce.model.ListInstanceGroupsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;

public class ListInstanceGroupsRequestMarshaller
implements Marshaller<Request<ListInstanceGroupsRequest>, ListInstanceGroupsRequest> {
    @Override
    public Request<ListInstanceGroupsRequest> marshall(ListInstanceGroupsRequest listInstanceGroupsRequest) {
        if (listInstanceGroupsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListInstanceGroupsRequest> request = new DefaultRequest<ListInstanceGroupsRequest>(listInstanceGroupsRequest, "AmazonElasticMapReduce");
        request.addHeader("X-Amz-Target", "ElasticMapReduce.ListInstanceGroups");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter(false, "1.1");
            jsonGenerator.writeStartObject();
            if (listInstanceGroupsRequest.getClusterId() != null) {
                jsonGenerator.writeFieldName("ClusterId").writeValue(listInstanceGroupsRequest.getClusterId());
            }
            if (listInstanceGroupsRequest.getMarker() != null) {
                jsonGenerator.writeFieldName("Marker").writeValue(listInstanceGroupsRequest.getMarker());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

