/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elasticmapreduce.model.DescribeStepRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;

public class DescribeStepRequestMarshaller
implements Marshaller<Request<DescribeStepRequest>, DescribeStepRequest> {
    @Override
    public Request<DescribeStepRequest> marshall(DescribeStepRequest describeStepRequest) {
        if (describeStepRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeStepRequest> request = new DefaultRequest<DescribeStepRequest>(describeStepRequest, "AmazonElasticMapReduce");
        request.addHeader("X-Amz-Target", "ElasticMapReduce.DescribeStep");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter(false, "1.1");
            jsonGenerator.writeStartObject();
            if (describeStepRequest.getClusterId() != null) {
                jsonGenerator.writeFieldName("ClusterId").writeValue(describeStepRequest.getClusterId());
            }
            if (describeStepRequest.getStepId() != null) {
                jsonGenerator.writeFieldName("StepId").writeValue(describeStepRequest.getStepId());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

