/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.gamelift.model.IpPermission;
import com.amazonaws.services.gamelift.model.UpdateFleetPortSettingsRequest;
import com.amazonaws.services.gamelift.model.transform.IpPermissionJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;
import java.util.List;

public class UpdateFleetPortSettingsRequestMarshaller
implements Marshaller<Request<UpdateFleetPortSettingsRequest>, UpdateFleetPortSettingsRequest> {
    @Override
    public Request<UpdateFleetPortSettingsRequest> marshall(UpdateFleetPortSettingsRequest updateFleetPortSettingsRequest) {
        if (updateFleetPortSettingsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateFleetPortSettingsRequest> request = new DefaultRequest<UpdateFleetPortSettingsRequest>(updateFleetPortSettingsRequest, "AmazonGameLift");
        request.addHeader("X-Amz-Target", "GameLift.UpdateFleetPortSettings");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            List<IpPermission> inboundPermissionRevocationsList;
            List<IpPermission> inboundPermissionAuthorizationsList;
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter(false, "1.1");
            jsonGenerator.writeStartObject();
            if (updateFleetPortSettingsRequest.getFleetId() != null) {
                jsonGenerator.writeFieldName("FleetId").writeValue(updateFleetPortSettingsRequest.getFleetId());
            }
            if ((inboundPermissionAuthorizationsList = updateFleetPortSettingsRequest.getInboundPermissionAuthorizations()) != null) {
                jsonGenerator.writeFieldName("InboundPermissionAuthorizations");
                jsonGenerator.writeStartArray();
                for (IpPermission inboundPermissionAuthorizationsListValue : inboundPermissionAuthorizationsList) {
                    if (inboundPermissionAuthorizationsListValue == null) continue;
                    IpPermissionJsonMarshaller.getInstance().marshall(inboundPermissionAuthorizationsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if ((inboundPermissionRevocationsList = updateFleetPortSettingsRequest.getInboundPermissionRevocations()) != null) {
                jsonGenerator.writeFieldName("InboundPermissionRevocations");
                jsonGenerator.writeStartArray();
                for (IpPermission inboundPermissionRevocationsListValue : inboundPermissionRevocationsList) {
                    if (inboundPermissionRevocationsListValue == null) continue;
                    IpPermissionJsonMarshaller.getInstance().marshall(inboundPermissionRevocationsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

