/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.transform.DescribeImagesRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class DescribeImagesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<DescribeImagesRequest> {
    private SdkInternalList<String> imageIds;
    private SdkInternalList<String> owners;
    private SdkInternalList<String> executableUsers;
    private SdkInternalList<Filter> filters;

    public List<String> getImageIds() {
        if (this.imageIds == null) {
            this.imageIds = new SdkInternalList();
        }
        return this.imageIds;
    }

    public void setImageIds(Collection<String> imageIds) {
        if (imageIds == null) {
            this.imageIds = null;
            return;
        }
        this.imageIds = new SdkInternalList<String>(imageIds);
    }

    public DescribeImagesRequest withImageIds(String ... imageIds) {
        if (this.imageIds == null) {
            this.setImageIds(new SdkInternalList<String>(imageIds.length));
        }
        for (String ele : imageIds) {
            this.imageIds.add(ele);
        }
        return this;
    }

    public DescribeImagesRequest withImageIds(Collection<String> imageIds) {
        this.setImageIds(imageIds);
        return this;
    }

    public List<String> getOwners() {
        if (this.owners == null) {
            this.owners = new SdkInternalList();
        }
        return this.owners;
    }

    public void setOwners(Collection<String> owners) {
        if (owners == null) {
            this.owners = null;
            return;
        }
        this.owners = new SdkInternalList<String>(owners);
    }

    public DescribeImagesRequest withOwners(String ... owners) {
        if (this.owners == null) {
            this.setOwners(new SdkInternalList<String>(owners.length));
        }
        for (String ele : owners) {
            this.owners.add(ele);
        }
        return this;
    }

    public DescribeImagesRequest withOwners(Collection<String> owners) {
        this.setOwners(owners);
        return this;
    }

    public List<String> getExecutableUsers() {
        if (this.executableUsers == null) {
            this.executableUsers = new SdkInternalList();
        }
        return this.executableUsers;
    }

    public void setExecutableUsers(Collection<String> executableUsers) {
        if (executableUsers == null) {
            this.executableUsers = null;
            return;
        }
        this.executableUsers = new SdkInternalList<String>(executableUsers);
    }

    public DescribeImagesRequest withExecutableUsers(String ... executableUsers) {
        if (this.executableUsers == null) {
            this.setExecutableUsers(new SdkInternalList<String>(executableUsers.length));
        }
        for (String ele : executableUsers) {
            this.executableUsers.add(ele);
        }
        return this;
    }

    public DescribeImagesRequest withExecutableUsers(Collection<String> executableUsers) {
        this.setExecutableUsers(executableUsers);
        return this;
    }

    public List<Filter> getFilters() {
        if (this.filters == null) {
            this.filters = new SdkInternalList();
        }
        return this.filters;
    }

    public void setFilters(Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        this.filters = new SdkInternalList<Filter>(filters);
    }

    public DescribeImagesRequest withFilters(Filter ... filters) {
        if (this.filters == null) {
            this.setFilters(new SdkInternalList<Filter>(filters.length));
        }
        for (Filter ele : filters) {
            this.filters.add(ele);
        }
        return this;
    }

    public DescribeImagesRequest withFilters(Collection<Filter> filters) {
        this.setFilters(filters);
        return this;
    }

    @Override
    public Request<DescribeImagesRequest> getDryRunRequest() {
        Request<DescribeImagesRequest> request = new DescribeImagesRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getImageIds() != null) {
            sb.append("ImageIds: " + this.getImageIds() + ",");
        }
        if (this.getOwners() != null) {
            sb.append("Owners: " + this.getOwners() + ",");
        }
        if (this.getExecutableUsers() != null) {
            sb.append("ExecutableUsers: " + this.getExecutableUsers() + ",");
        }
        if (this.getFilters() != null) {
            sb.append("Filters: " + this.getFilters());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImagesRequest)) {
            return false;
        }
        DescribeImagesRequest other = (DescribeImagesRequest)obj;
        if (other.getImageIds() == null ^ this.getImageIds() == null) {
            return false;
        }
        if (other.getImageIds() != null && !other.getImageIds().equals(this.getImageIds())) {
            return false;
        }
        if (other.getOwners() == null ^ this.getOwners() == null) {
            return false;
        }
        if (other.getOwners() != null && !other.getOwners().equals(this.getOwners())) {
            return false;
        }
        if (other.getExecutableUsers() == null ^ this.getExecutableUsers() == null) {
            return false;
        }
        if (other.getExecutableUsers() != null && !other.getExecutableUsers().equals(this.getExecutableUsers())) {
            return false;
        }
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        return other.getFilters() == null || other.getFilters().equals(this.getFilters());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getImageIds() == null ? 0 : this.getImageIds().hashCode());
        hashCode = 31 * hashCode + (this.getOwners() == null ? 0 : this.getOwners().hashCode());
        hashCode = 31 * hashCode + (this.getExecutableUsers() == null ? 0 : this.getExecutableUsers().hashCode());
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        return hashCode;
    }

    @Override
    public DescribeImagesRequest clone() {
        return (DescribeImagesRequest)super.clone();
    }
}

