/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ModifyDBSnapshotAttributeRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String dBSnapshotIdentifier;
    private String attributeName;
    private ListWithAutoConstructFlag<String> valuesToAdd;
    private ListWithAutoConstructFlag<String> valuesToRemove;

    public String getDBSnapshotIdentifier() {
        return this.dBSnapshotIdentifier;
    }

    public void setDBSnapshotIdentifier(String dBSnapshotIdentifier) {
        this.dBSnapshotIdentifier = dBSnapshotIdentifier;
    }

    public ModifyDBSnapshotAttributeRequest withDBSnapshotIdentifier(String dBSnapshotIdentifier) {
        this.dBSnapshotIdentifier = dBSnapshotIdentifier;
        return this;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public ModifyDBSnapshotAttributeRequest withAttributeName(String attributeName) {
        this.attributeName = attributeName;
        return this;
    }

    public List<String> getValuesToAdd() {
        if (this.valuesToAdd == null) {
            this.valuesToAdd = new ListWithAutoConstructFlag();
            this.valuesToAdd.setAutoConstruct(true);
        }
        return this.valuesToAdd;
    }

    public void setValuesToAdd(Collection<String> valuesToAdd) {
        if (valuesToAdd == null) {
            this.valuesToAdd = null;
            return;
        }
        ListWithAutoConstructFlag valuesToAddCopy = new ListWithAutoConstructFlag(valuesToAdd.size());
        valuesToAddCopy.addAll(valuesToAdd);
        this.valuesToAdd = valuesToAddCopy;
    }

    public ModifyDBSnapshotAttributeRequest withValuesToAdd(String ... valuesToAdd) {
        if (this.getValuesToAdd() == null) {
            this.setValuesToAdd(new ArrayList<String>(valuesToAdd.length));
        }
        for (String value : valuesToAdd) {
            this.getValuesToAdd().add(value);
        }
        return this;
    }

    public ModifyDBSnapshotAttributeRequest withValuesToAdd(Collection<String> valuesToAdd) {
        if (valuesToAdd == null) {
            this.valuesToAdd = null;
        } else {
            ListWithAutoConstructFlag valuesToAddCopy = new ListWithAutoConstructFlag(valuesToAdd.size());
            valuesToAddCopy.addAll(valuesToAdd);
            this.valuesToAdd = valuesToAddCopy;
        }
        return this;
    }

    public List<String> getValuesToRemove() {
        if (this.valuesToRemove == null) {
            this.valuesToRemove = new ListWithAutoConstructFlag();
            this.valuesToRemove.setAutoConstruct(true);
        }
        return this.valuesToRemove;
    }

    public void setValuesToRemove(Collection<String> valuesToRemove) {
        if (valuesToRemove == null) {
            this.valuesToRemove = null;
            return;
        }
        ListWithAutoConstructFlag valuesToRemoveCopy = new ListWithAutoConstructFlag(valuesToRemove.size());
        valuesToRemoveCopy.addAll(valuesToRemove);
        this.valuesToRemove = valuesToRemoveCopy;
    }

    public ModifyDBSnapshotAttributeRequest withValuesToRemove(String ... valuesToRemove) {
        if (this.getValuesToRemove() == null) {
            this.setValuesToRemove(new ArrayList<String>(valuesToRemove.length));
        }
        for (String value : valuesToRemove) {
            this.getValuesToRemove().add(value);
        }
        return this;
    }

    public ModifyDBSnapshotAttributeRequest withValuesToRemove(Collection<String> valuesToRemove) {
        if (valuesToRemove == null) {
            this.valuesToRemove = null;
        } else {
            ListWithAutoConstructFlag valuesToRemoveCopy = new ListWithAutoConstructFlag(valuesToRemove.size());
            valuesToRemoveCopy.addAll(valuesToRemove);
            this.valuesToRemove = valuesToRemoveCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDBSnapshotIdentifier() != null) {
            sb.append("DBSnapshotIdentifier: " + this.getDBSnapshotIdentifier() + ",");
        }
        if (this.getAttributeName() != null) {
            sb.append("AttributeName: " + this.getAttributeName() + ",");
        }
        if (this.getValuesToAdd() != null) {
            sb.append("ValuesToAdd: " + this.getValuesToAdd() + ",");
        }
        if (this.getValuesToRemove() != null) {
            sb.append("ValuesToRemove: " + this.getValuesToRemove());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDBSnapshotIdentifier() == null ? 0 : this.getDBSnapshotIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getAttributeName() == null ? 0 : this.getAttributeName().hashCode());
        hashCode = 31 * hashCode + (this.getValuesToAdd() == null ? 0 : this.getValuesToAdd().hashCode());
        hashCode = 31 * hashCode + (this.getValuesToRemove() == null ? 0 : this.getValuesToRemove().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyDBSnapshotAttributeRequest)) {
            return false;
        }
        ModifyDBSnapshotAttributeRequest other = (ModifyDBSnapshotAttributeRequest)obj;
        if (other.getDBSnapshotIdentifier() == null ^ this.getDBSnapshotIdentifier() == null) {
            return false;
        }
        if (other.getDBSnapshotIdentifier() != null && !other.getDBSnapshotIdentifier().equals(this.getDBSnapshotIdentifier())) {
            return false;
        }
        if (other.getAttributeName() == null ^ this.getAttributeName() == null) {
            return false;
        }
        if (other.getAttributeName() != null && !other.getAttributeName().equals(this.getAttributeName())) {
            return false;
        }
        if (other.getValuesToAdd() == null ^ this.getValuesToAdd() == null) {
            return false;
        }
        if (other.getValuesToAdd() != null && !other.getValuesToAdd().equals(this.getValuesToAdd())) {
            return false;
        }
        if (other.getValuesToRemove() == null ^ this.getValuesToRemove() == null) {
            return false;
        }
        return other.getValuesToRemove() == null || other.getValuesToRemove().equals(this.getValuesToRemove());
    }

    @Override
    public ModifyDBSnapshotAttributeRequest clone() {
        return (ModifyDBSnapshotAttributeRequest)super.clone();
    }
}

