/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.elasticmapreduce.model.StepSummary;
import com.amazonaws.services.elasticmapreduce.model.transform.HadoopStepConfigJsonMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.StepStatusJsonMarshaller;
import com.amazonaws.util.json.StructuredJsonGenerator;

public class StepSummaryJsonMarshaller {
    private static StepSummaryJsonMarshaller instance;

    public void marshall(StepSummary stepSummary, StructuredJsonGenerator jsonGenerator) {
        if (stepSummary == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (stepSummary.getId() != null) {
                jsonGenerator.writeFieldName("Id").writeValue(stepSummary.getId());
            }
            if (stepSummary.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(stepSummary.getName());
            }
            if (stepSummary.getConfig() != null) {
                jsonGenerator.writeFieldName("Config");
                HadoopStepConfigJsonMarshaller.getInstance().marshall(stepSummary.getConfig(), jsonGenerator);
            }
            if (stepSummary.getActionOnFailure() != null) {
                jsonGenerator.writeFieldName("ActionOnFailure").writeValue(stepSummary.getActionOnFailure());
            }
            if (stepSummary.getStatus() != null) {
                jsonGenerator.writeFieldName("Status");
                StepStatusJsonMarshaller.getInstance().marshall(stepSummary.getStatus(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static StepSummaryJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new StepSummaryJsonMarshaller();
        }
        return instance;
    }
}

