/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticmapreduce.model.BootstrapActionDetail;
import com.amazonaws.services.elasticmapreduce.model.JobFlowDetail;
import com.amazonaws.services.elasticmapreduce.model.StepDetail;
import com.amazonaws.services.elasticmapreduce.model.transform.BootstrapActionDetailJsonMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.JobFlowExecutionStatusDetailJsonMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.JobFlowInstancesDetailJsonMarshaller;
import com.amazonaws.services.elasticmapreduce.model.transform.StepDetailJsonMarshaller;
import com.amazonaws.util.json.StructuredJsonGenerator;

public class JobFlowDetailJsonMarshaller {
    private static JobFlowDetailJsonMarshaller instance;

    public void marshall(JobFlowDetail jobFlowDetail, StructuredJsonGenerator jsonGenerator) {
        if (jobFlowDetail == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList supportedProductsList;
            SdkInternalList bootstrapActionsList;
            SdkInternalList stepsList;
            jsonGenerator.writeStartObject();
            if (jobFlowDetail.getJobFlowId() != null) {
                jsonGenerator.writeFieldName("JobFlowId").writeValue(jobFlowDetail.getJobFlowId());
            }
            if (jobFlowDetail.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(jobFlowDetail.getName());
            }
            if (jobFlowDetail.getLogUri() != null) {
                jsonGenerator.writeFieldName("LogUri").writeValue(jobFlowDetail.getLogUri());
            }
            if (jobFlowDetail.getAmiVersion() != null) {
                jsonGenerator.writeFieldName("AmiVersion").writeValue(jobFlowDetail.getAmiVersion());
            }
            if (jobFlowDetail.getExecutionStatusDetail() != null) {
                jsonGenerator.writeFieldName("ExecutionStatusDetail");
                JobFlowExecutionStatusDetailJsonMarshaller.getInstance().marshall(jobFlowDetail.getExecutionStatusDetail(), jsonGenerator);
            }
            if (jobFlowDetail.getInstances() != null) {
                jsonGenerator.writeFieldName("Instances");
                JobFlowInstancesDetailJsonMarshaller.getInstance().marshall(jobFlowDetail.getInstances(), jsonGenerator);
            }
            if (!(stepsList = (SdkInternalList)jobFlowDetail.getSteps()).isEmpty() || !stepsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Steps");
                jsonGenerator.writeStartArray();
                for (StepDetail stepsListValue : stepsList) {
                    if (stepsListValue == null) continue;
                    StepDetailJsonMarshaller.getInstance().marshall(stepsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (!(bootstrapActionsList = (SdkInternalList)jobFlowDetail.getBootstrapActions()).isEmpty() || !bootstrapActionsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("BootstrapActions");
                jsonGenerator.writeStartArray();
                for (BootstrapActionDetail bootstrapActionsListValue : bootstrapActionsList) {
                    if (bootstrapActionsListValue == null) continue;
                    BootstrapActionDetailJsonMarshaller.getInstance().marshall(bootstrapActionsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (!(supportedProductsList = (SdkInternalList)jobFlowDetail.getSupportedProducts()).isEmpty() || !supportedProductsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("SupportedProducts");
                jsonGenerator.writeStartArray();
                for (String supportedProductsListValue : supportedProductsList) {
                    if (supportedProductsListValue == null) continue;
                    jsonGenerator.writeValue(supportedProductsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (jobFlowDetail.getVisibleToAllUsers() != null) {
                jsonGenerator.writeFieldName("VisibleToAllUsers").writeValue(jobFlowDetail.getVisibleToAllUsers());
            }
            if (jobFlowDetail.getJobFlowRole() != null) {
                jsonGenerator.writeFieldName("JobFlowRole").writeValue(jobFlowDetail.getJobFlowRole());
            }
            if (jobFlowDetail.getServiceRole() != null) {
                jsonGenerator.writeFieldName("ServiceRole").writeValue(jobFlowDetail.getServiceRole());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static JobFlowDetailJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new JobFlowDetailJsonMarshaller();
        }
        return instance;
    }
}

