/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidentity.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cognitoidentity.model.DeleteIdentitiesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;
import java.util.List;

public class DeleteIdentitiesRequestMarshaller
implements Marshaller<Request<DeleteIdentitiesRequest>, DeleteIdentitiesRequest> {
    @Override
    public Request<DeleteIdentitiesRequest> marshall(DeleteIdentitiesRequest deleteIdentitiesRequest) {
        if (deleteIdentitiesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteIdentitiesRequest> request = new DefaultRequest<DeleteIdentitiesRequest>(deleteIdentitiesRequest, "AmazonCognitoIdentity");
        request.addHeader("X-Amz-Target", "AWSCognitoIdentityService.DeleteIdentities");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter(false, "1.1");
            jsonGenerator.writeStartObject();
            List<String> identityIdsToDeleteList = deleteIdentitiesRequest.getIdentityIdsToDelete();
            if (identityIdsToDeleteList != null) {
                jsonGenerator.writeFieldName("IdentityIdsToDelete");
                jsonGenerator.writeStartArray();
                for (String identityIdsToDeleteListValue : identityIdsToDeleteList) {
                    if (identityIdsToDeleteListValue == null) continue;
                    jsonGenerator.writeValue(identityIdsToDeleteListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

