/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.codedeploy.model.BatchGetDeploymentGroupsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;

public class BatchGetDeploymentGroupsRequestMarshaller
implements Marshaller<Request<BatchGetDeploymentGroupsRequest>, BatchGetDeploymentGroupsRequest> {
    @Override
    public Request<BatchGetDeploymentGroupsRequest> marshall(BatchGetDeploymentGroupsRequest batchGetDeploymentGroupsRequest) {
        if (batchGetDeploymentGroupsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<BatchGetDeploymentGroupsRequest> request = new DefaultRequest<BatchGetDeploymentGroupsRequest>(batchGetDeploymentGroupsRequest, "AmazonCodeDeploy");
        request.addHeader("X-Amz-Target", "CodeDeploy_20141006.BatchGetDeploymentGroups");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList deploymentGroupNamesList;
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter(false, "1.1");
            jsonGenerator.writeStartObject();
            if (batchGetDeploymentGroupsRequest.getApplicationName() != null) {
                jsonGenerator.writeFieldName("applicationName").writeValue(batchGetDeploymentGroupsRequest.getApplicationName());
            }
            if (!(deploymentGroupNamesList = (SdkInternalList)batchGetDeploymentGroupsRequest.getDeploymentGroupNames()).isEmpty() || !deploymentGroupNamesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("deploymentGroupNames");
                jsonGenerator.writeStartArray();
                for (String deploymentGroupNamesListValue : deploymentGroupNamesList) {
                    if (deploymentGroupNamesListValue == null) continue;
                    jsonGenerator.writeValue(deploymentGroupNamesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

