/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.apigateway.model.PutRestApiRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.BinaryUtils;
import com.amazonaws.util.StringUtils;
import java.util.Map;

public class PutRestApiRequestMarshaller
implements Marshaller<Request<PutRestApiRequest>, PutRestApiRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    @Override
    public Request<PutRestApiRequest> marshall(PutRestApiRequest putRestApiRequest) {
        Map<String, String> parameters;
        if (putRestApiRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PutRestApiRequest> request = new DefaultRequest<PutRestApiRequest>(putRestApiRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.PUT);
        String uriResourcePath = "/restapis/{restapi_id}";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", putRestApiRequest.getRestApiId() != null ? StringUtils.fromString(putRestApiRequest.getRestApiId()) : DEFAULT_CONTENT_TYPE);
        request.setResourcePath(uriResourcePath);
        if (putRestApiRequest.getMode() != null) {
            request.addParameter("mode", StringUtils.fromString(putRestApiRequest.getMode()));
        }
        if (putRestApiRequest.getFailOnWarnings() != null) {
            request.addParameter("failonwarnings", StringUtils.fromBoolean(putRestApiRequest.getFailOnWarnings()));
        }
        if ((parameters = putRestApiRequest.getParameters()) != null) {
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                if (entry.getValue() == null) continue;
                request.addParameter(StringUtils.fromString(entry.getKey()), StringUtils.fromString(entry.getValue()));
            }
        }
        request.setContent(BinaryUtils.toStream(putRestApiRequest.getBody()));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

