/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.apigateway.model.Method;
import com.amazonaws.services.apigateway.model.MethodResponse;
import com.amazonaws.services.apigateway.model.transform.IntegrationJsonMarshaller;
import com.amazonaws.services.apigateway.model.transform.MethodResponseJsonMarshaller;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.util.Map;

public class MethodJsonMarshaller {
    private static MethodJsonMarshaller instance;

    public void marshall(Method method, StructuredJsonGenerator jsonGenerator) {
        if (method == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            Map<String, MethodResponse> methodResponsesMap;
            Map<String, String> requestModelsMap;
            Map<String, Boolean> requestParametersMap;
            jsonGenerator.writeStartObject();
            if (method.getHttpMethod() != null) {
                jsonGenerator.writeFieldName("httpMethod").writeValue(method.getHttpMethod());
            }
            if (method.getAuthorizationType() != null) {
                jsonGenerator.writeFieldName("authorizationType").writeValue(method.getAuthorizationType());
            }
            if (method.getAuthorizerId() != null) {
                jsonGenerator.writeFieldName("authorizerId").writeValue(method.getAuthorizerId());
            }
            if (method.getApiKeyRequired() != null) {
                jsonGenerator.writeFieldName("apiKeyRequired").writeValue(method.getApiKeyRequired());
            }
            if ((requestParametersMap = method.getRequestParameters()) != null) {
                jsonGenerator.writeFieldName("requestParameters");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, Boolean> requestParametersMapValue : requestParametersMap.entrySet()) {
                    if (requestParametersMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(requestParametersMapValue.getKey());
                    jsonGenerator.writeValue(requestParametersMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            if ((requestModelsMap = method.getRequestModels()) != null) {
                jsonGenerator.writeFieldName("requestModels");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, String> requestModelsMapValue : requestModelsMap.entrySet()) {
                    if (requestModelsMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(requestModelsMapValue.getKey());
                    jsonGenerator.writeValue(requestModelsMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            if ((methodResponsesMap = method.getMethodResponses()) != null) {
                jsonGenerator.writeFieldName("methodResponses");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, MethodResponse> methodResponsesMapValue : methodResponsesMap.entrySet()) {
                    if (methodResponsesMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(methodResponsesMapValue.getKey());
                    MethodResponseJsonMarshaller.getInstance().marshall(methodResponsesMapValue.getValue(), jsonGenerator);
                }
                jsonGenerator.writeEndObject();
            }
            if (method.getMethodIntegration() != null) {
                jsonGenerator.writeFieldName("methodIntegration");
                IntegrationJsonMarshaller.getInstance().marshall(method.getMethodIntegration(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static MethodJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new MethodJsonMarshaller();
        }
        return instance;
    }
}

