/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.machinelearning.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.machinelearning.model.DataSource;
import com.amazonaws.services.machinelearning.model.transform.RDSMetadataJsonMarshaller;
import com.amazonaws.services.machinelearning.model.transform.RedshiftMetadataJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class DataSourceJsonMarshaller {
    private static DataSourceJsonMarshaller instance;

    public void marshall(DataSource dataSource, JSONWriter jsonWriter) {
        if (dataSource == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (dataSource.getDataSourceId() != null) {
                jsonWriter.key("DataSourceId").value(dataSource.getDataSourceId());
            }
            if (dataSource.getDataLocationS3() != null) {
                jsonWriter.key("DataLocationS3").value(dataSource.getDataLocationS3());
            }
            if (dataSource.getDataRearrangement() != null) {
                jsonWriter.key("DataRearrangement").value(dataSource.getDataRearrangement());
            }
            if (dataSource.getCreatedByIamUser() != null) {
                jsonWriter.key("CreatedByIamUser").value(dataSource.getCreatedByIamUser());
            }
            if (dataSource.getCreatedAt() != null) {
                jsonWriter.key("CreatedAt").value(dataSource.getCreatedAt());
            }
            if (dataSource.getLastUpdatedAt() != null) {
                jsonWriter.key("LastUpdatedAt").value(dataSource.getLastUpdatedAt());
            }
            if (dataSource.getDataSizeInBytes() != null) {
                jsonWriter.key("DataSizeInBytes").value(dataSource.getDataSizeInBytes());
            }
            if (dataSource.getNumberOfFiles() != null) {
                jsonWriter.key("NumberOfFiles").value(dataSource.getNumberOfFiles());
            }
            if (dataSource.getName() != null) {
                jsonWriter.key("Name").value(dataSource.getName());
            }
            if (dataSource.getStatus() != null) {
                jsonWriter.key("Status").value(dataSource.getStatus());
            }
            if (dataSource.getMessage() != null) {
                jsonWriter.key("Message").value(dataSource.getMessage());
            }
            if (dataSource.getRedshiftMetadata() != null) {
                jsonWriter.key("RedshiftMetadata");
                RedshiftMetadataJsonMarshaller.getInstance().marshall(dataSource.getRedshiftMetadata(), jsonWriter);
            }
            if (dataSource.getRDSMetadata() != null) {
                jsonWriter.key("RDSMetadata");
                RDSMetadataJsonMarshaller.getInstance().marshall(dataSource.getRDSMetadata(), jsonWriter);
            }
            if (dataSource.getRoleARN() != null) {
                jsonWriter.key("RoleARN").value(dataSource.getRoleARN());
            }
            if (dataSource.getComputeStatistics() != null) {
                jsonWriter.key("ComputeStatistics").value(dataSource.getComputeStatistics());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static DataSourceJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new DataSourceJsonMarshaller();
        }
        return instance;
    }
}

